import { useNavigate } from "react-router";

import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faArrowAltCircleLeft } from "@fortawesome/free-solid-svg-icons";

import './style.css'

const BackButtonWithPage = ({ page }) => {
  const navigate = useNavigate();

  const goBack = () => {
    navigate(page)
  };

  return (
    <button className="backButton primaryColor" onClick={goBack}>
      <FontAwesomeIcon icon={faArrowAltCircleLeft} />
    </button>
  );
};

export default BackButtonWithPage;
