import { useNavigate } from "react-router";

import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faArrowAltCircleLeft } from "@fortawesome/free-solid-svg-icons";

import './style.css'

const BackButton = () => {
  const navigate = useNavigate();

  const goBack = () => {
    navigate(-1)
  };

  return (
    <button className="backButton primaryColor" onClick={goBack}>
      <FontAwesomeIcon icon={faArrowAltCircleLeft} />
    </button>
  );
};

export default BackButton;
