import React from "react";
import { Formik } from "formik";
import { changePassword } from "../../Config/Validations";
import CustomInput from "../CustomInput";
import CustomButton from "../CustomButton";

const ChangePasswordForm = ({ onSubmit, isSubmitting, errors }) => {
  return (
    <Formik
      initialValues={{
        current_password: "",
        password: "",
        password_confirmation: "",
      }}
      validationSchema={changePassword}
      onSubmit={onSubmit}
    >
      {({
        values,
        errors,
        touched,
        handleChange,
        handleBlur,
        handleSubmit,
      }) => (
        <form onSubmit={handleSubmit} className="pCPass">
          <div className="row mb-3">
            <div className="col-md-12">
              <CustomInput
                label="Current Password"
                labelclass="mainLabel"
                type="password"
                placeholder="Enter Current Password"
                inputclass="mainInput"
                id="current_password"
                value={values.current_password}
                onChange={handleChange}
                onBlur={handleBlur}
                error={touched.current_password && errors.current_password}
              />
            </div>
            <div className="col-md-12">
              <CustomInput
                label="New Password"
                labelclass="mainLabel"
                type="password"
                placeholder="Enter New Password"
                inputclass="mainInput"
                id="password"
                value={values.password}
                onChange={handleChange}
                onBlur={handleBlur}
                error={touched.password && errors.password}
              />
            </div>
            <div className="col-md-12">
              <CustomInput
                label="Confirm New Password"
                labelclass="mainLabel"
                type="password"
                placeholder="Confirm New Password"
                inputclass="mainInput"
                id="password_confirmation"
                value={values.password_confirmation}
                onChange={handleChange}
                onBlur={handleBlur}
                error={
                  touched.password_confirmation && errors.password_confirmation
                }
              />
            </div>
          </div>
          <div className="row mb-3">
            <div className="col-md-12">
              <CustomButton
                variant="btnBlueBG"
                className="px-5"
                text="Update"
                pendingText="Submitting..."
                isPending={isSubmitting}
                type="submit"
              />
            </div>
          </div>
        </form>
      )}
    </Formik>
  );
};

export default ChangePasswordForm;
