import { Formik } from "formik";
import { contactValidationSchema } from "../../Config/Validations";
import CustomInput from "../CustomInput";
import CustomButton from "../CustomButton";
import { useAuth } from "../../Hooks/useAuth";

const ContactForm = ({ handleSubmit }) => {
  const { user } = useAuth();

  return (
    <Formik
      initialValues={{
        first_name: user?.first_name || "",
        last_name: user?.last_name || "",
        email: user?.email || "",
        subject: "",
        message: "",
        user_id: user?.id || null,
      }}
      validationSchema={contactValidationSchema}
      onSubmit={handleSubmit}
    >
      {({
        values,
        errors,
        touched,
        handleChange,
        handleBlur,
        handleSubmit,
        isSubmitting, // You can use this to disable the button while submitting
      }) => (
        <form onSubmit={handleSubmit}>
          <div className="col-md-12">
            <CustomInput
              label="First Name"
              labelclass="mainLabel"
              type="text"
              placeholder="Enter First Name"
              inputclass="mainInput"
              id="first_name"

              value={values.first_name}
              onChange={handleChange}
              onBlur={handleBlur}
              error={touched.first_name && errors.first_name}
            />
            <CustomInput
              label="Last Name"
              labelclass="mainLabel"
              type="text"
              placeholder="Enter Last Name"
              inputclass="mainInput"
              id="last_name"

              value={values.last_name}
              onChange={handleChange}
              onBlur={handleBlur}
              error={touched.last_name && errors.last_name}
            />
            <CustomInput
              label="Email Address"
              labelclass="mainLabel"
              type="email"
              placeholder="Enter Email Address"
              inputclass="mainInput"
              id="email"

              value={values.email}
              onChange={handleChange}
              onBlur={handleBlur}
              error={touched.email && errors.email}
            />
            <CustomInput
              label="Subject"
              labelclass="mainLabel"
              type="text"
              placeholder="Enter Subject"
              inputclass="mainInput"
              id="subject"

              value={values.subject}
              onChange={handleChange}
              onBlur={handleBlur}
              error={touched.subject && errors.subject}
            />
            <CustomInput
              label="Message"
              labelclass="mainLabel"
              rows="8"
              type="textarea"
              placeholder="Write here..."
              inputclass="mainInput"
              id="message"

              value={values.message}
              onChange={handleChange}
              onBlur={handleBlur}
              error={touched.message && errors.message}
            />
            <div className="text-center mt-4">
              <CustomButton
                className="btnBlueBG px-5"
                text="Submit"
                type="submit"
                disabled={isSubmitting} // Disable button while submitting
              />
            </div>
          </div>
        </form>
      )}
    </Formik>
  );
};

export default ContactForm;
