import React from "react";
import PropTypes from "prop-types";
import "./style.css";

const CustomButton = ({
  variant = '',
  className = '',
  type = 'button',
  onClick = () => { },
  isPending = false,
  text = 'Submit',
}) => {
  return (
    <button
      className={`site-btn ${variant} ${className}`}
      type={type}
      onClick={onClick}
      disabled={isPending}
    >
      {text}
    </button>
  );
};

CustomButton.propTypes = {
  variant: PropTypes.string,
  className: PropTypes.string,
  type: PropTypes.string,
  onClick: PropTypes.func,
  isPending: PropTypes.bool,
  pendingText: PropTypes.string,
  text: PropTypes.string,
};

export default CustomButton;
