import React from "react";
import { Modal } from "react-bootstrap";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faTimes } from "@fortawesome/free-solid-svg-icons";
import CustomButton from "../CustomButton";
import { images } from "../../Assets";
import "./style.css";
import StarRating from "../user/StarRating/StarRating";
import { Formik, Form, Field, ErrorMessage } from "formik";
import * as Yup from "yup";
import CustomInput from "../CustomInput";
const validationSchema = Yup.object().shape({
  rating: Yup.number().required("Rating is required").min(1, "Minimum rating is 1"),
  review: Yup.string().required("Review is required").min(10, "Review must be at least 10 characters long"),
});

const reportValidationSchema = Yup.object().shape({
  reason: Yup.string().required("Reason is required").min(10, "Reason must be at least 10 characters long"),
});
const CustomModal = (props) => {
  const handleSubmit = (values) => {
    // console.log("dd", values);
    // props.reason(values)
    props.onSubmit(values); // Send data back to the parent component
  };
  return (
    <Modal show={props?.show} centered onHide={props?.close}>
      <button className="closeButton" onClick={props?.close}>
        <FontAwesomeIcon icon={faTimes} />
      </button>
      <Modal.Body className="text-center">
        {props?.success ? (
          <img src={images.Check} alt="check" className="modalImage" />
        ) : props?.showReason || props.rateProduct ? (
          ""
        ) : (
          <img src={images.Question} alt="question" className="modalImage" />
        )}
        <div className="modalContent">
          <h2 className="modalHeading">
            {props?.showReason ? "" : props?.heading}
          </h2>
          <p className="modalpara">{props?.para}</p>
          {props?.showReason && (
            // <div className="modalReason mb-3 mt-0 text-start">
            //   <label className="mainLabel">{props?.reasonLabel}</label>
            //   <textarea
            //     className="mainInput"
            //     placeholder={props?.reasonPlaceholder}
            //     rows="4"
            //     onChange={props?.onChange}
            //     value={props?.value}
            //   ></textarea>
            //   {props?.errorMessage && (
            //     <p className="text-danger">{props?.errorMessage}</p> // Display error message
            //   )}
            // </div>
            <Formik
              initialValues={{ reason: "" }} // Set initial values for the form
              validationSchema={reportValidationSchema} // Attach Yup validation schema
              onSubmit={handleSubmit} // Form submission handler
            >
              {({ setFieldValue, values }) => (
                <Form>
                  <div className="mb-4">
                    <Field
                      as="textarea"
                      name="reason"
                      placeholder="Write a reason"
                      className="mainInput"
                      rows="7"
                    />
                    <ErrorMessage name="reason" component="div" className="text-danger" />
                  </div>
                  <CustomButton type="submit" className="btnBlueBG px-5" text="Submit" />
                </Form>
              )}
            </Formik>
          )}
          {props?.rateProduct && (
            <Formik
              initialValues={{ rating: 3, review: "" }} // Set initial values for the form
              validationSchema={validationSchema} // Attach Yup validation schema
              onSubmit={handleSubmit} // Form submission handler
            >
              {({ setFieldValue, values }) => (
                <Form>
                  <div className="mb-4">
                    <StarRating
                      totalStars={5}
                      initialRating={values.rating}
                      onRatingChange={(newRating) => setFieldValue("rating", newRating)}
                    />
                    <ErrorMessage name="rating" component="div" className="text-danger" />
                  </div>
                  <div className="mb-4">
                    <Field
                      as="textarea"
                      name="review"
                      placeholder="Write a review"
                      className="mainInput"
                      rows="7"
                    />
                    <ErrorMessage name="review" component="div" className="text-danger" />
                  </div>

                  <CustomButton type="submit" className="btnBlueBG px-5" text="Ok" />
                </Form>
              )}
            </Formik>
          )}
          {props?.success ? (
            <CustomButton
              onClick={props?.close}
              className="btnBlueBG px-5"
              text="Ok"
            />
          ) : props?.rateProduct ? (
            ""
          ) : props?.showReason ? (
            // <>
            //   <CustomButton
            //     onClick={props?.action} // Ensure this is a function
            //     variant="btnBlueBG"
            //     text={props?.btnText}
            //   />
            //   <CustomButton
            //     onClick={props?.close}
            //     variant="btngrayBG ms-2 px-5"
            //     text="Cancel"
            //   />
            // </>
            ""
          ) : props?.alert ? (
            <>
              <CustomButton
                onClick={props?.close}
                className="btnBlueBG px-5"
                text="Ok"
              />
            </>
          ) : (
            <>
              <CustomButton
                onClick={props?.action} // Ensure this is a function
                variant="btnBlueBG px-5"
                text="Yes"
                className="me-2"
              />
              <CustomButton
                onClick={props?.close}
                variant="btngrayBG px-5"
                text="No"
              />
            </>
          )}
        </div>
      </Modal.Body>
    </Modal>
  );
};

export default CustomModal;
