import React from "react";
import CustomFilters from "../CustomFilters";
import CustomPagination from "../CustomPagination";
import LoadingSpinner from "../Loader";
import "./style.css";

const CustomTable = (props) => {
  return (
    <>
      {props?.noFilters ? ('') : (
        <CustomFilters
          filters={props?.filters}
          setFilters={props?.setFilters}
          selectOptions={props?.selectOptions}
          dateFilters={props?.dateFilters}
        />
      )}
      <div className="customTable mt-4 pb-4 table-responsive position-relative">
        {props?.loading && (
          <div className="loading-overlay">
            <LoadingSpinner />
          </div>
        )}
        <table>
          <thead>
            <tr>
              {props?.headers.map((header) => (
                <th key={header?.key}>{header?.title}</th>
              ))}
            </tr>
          </thead>
          {props?.children?.props?.children?.length === 0 ? (
            <tbody>
              <tr>
                <td
                  colSpan={props?.headers?.length}
                  style={{ textAlign: "center" }}
                >
                  No Records Found
                </td>
              </tr>
            </tbody>
          ) : (
            props?.children
          )}
        </table>
      </div>
      {props?.pagination ? (
        <CustomPagination
          pagination={props?.pagination}
          setFilters={props?.setFilters}
        />
      ) : ''}
    </>
  );
};

export default CustomTable;

