import React from 'react';
import { Field, ErrorMessage } from 'formik';

const FormikField = ({ name, label, as = 'input', placeholder, rows, className, labelClass, span, type }) => (
    <div className="col-xl-12 col-md-12 mb-3">
        <label className={labelClass}>{label}{span ? <span className="red-text">*</span> : ""}</label>
        <Field
            as={as}
            name={name}
            placeholder={placeholder}
            type={type}
            rows={rows}
            className={className}
        />
        <ErrorMessage name={name} component="div" className="errorText red-text" />
    </div>
);

export default React.memo(FormikField);
