import React, { useState, useEffect } from "react";

const GoogleMapComponent = ({ initialLat, initialLng, onLocationChange }) => {
  const [map, setMap] = useState(null);
  const [marker, setMarker] = useState(null);

  useEffect(() => {
    // Initialize the map if initial coordinates are provided
    if (initialLat !== undefined && initialLng !== undefined) {
      const googleMap = new window.google.maps.Map(
        document.getElementById("map"),
        {
          center: { lat: initialLat, lng: initialLng },
          zoom: 12,
          mapId: "286dcdf612d85f84", // Replace with your map ID
        }
      );
      setMap(googleMap);

      // Create a new advanced marker
      const newMarker = new google.maps.marker.AdvancedMarkerElement({
        map: googleMap,
        position: { lat: initialLat, lng: initialLng },
        draggable: true,
        title: "Pakistan",
      });

      // Set the new marker
      setMarker(newMarker);
    }
  }, [initialLat, initialLng]);

  useEffect(() => {
    if (!map) return;

    const onClickMap = (event) => {
      const { latLng } = event;
      const lat = latLng.lat();
      const lng = latLng.lng();

      // Create a new advanced marker
      const newMarker = new google.maps.marker.AdvancedMarkerElement({
        map,
        position: { lat, lng },
        draggable: true,
        title: "Pakistan",
      });

      // Remove the previous marker if it exists
      if (marker && typeof marker.setMap === "function") {
        marker.setMap(null);
      }

      // Set the new marker
      setMarker(newMarker);

      // Notify parent component about the location change
      onLocationChange({ lat, lng });
    };

    // Add click event listener to the map
    map.addListener("click", onClickMap);

    return () => {
      // Remove event listener using google.maps.event.removeListener
      google.maps.event.clearListeners(map, "click");
    };
  }, [map, marker, onLocationChange]);

  useEffect(() => {
    if (map && marker) {
      // Center the map on the marker
      map.panTo(marker.position);
    }
  }, [map, marker]);

  return <div id="map" style={{ height: "400px", width: "100%" }}></div>;
};

export default GoogleMapComponent;
