import React, { useEffect, useRef, useState } from 'react';
import { useLocation } from 'react-router-dom';
import { GoogleMap, Marker, InfoWindow } from '@react-google-maps/api';
import { usePageTitle } from '../../Utils/helper';

const GoogleMarker = () => {

    const location = useLocation();
    const queryParams = new URLSearchParams(location.search);
    const lat = parseFloat(queryParams.get('lat'));
    const lng = parseFloat(queryParams.get('lng'));
    const name = queryParams.get('name');
    usePageTitle(name);
    const [selected, setSelected] = useState(null);


    const containerStyle = {
        width: '100%',
        height: '790px',
    };

    const center = {
        lat: lat,
        lng: lng,
    };
    const markerRef = useRef(null);
    const infoWindowRef = useRef(null);

    useEffect(() => {
        if (infoWindowRef.current && markerRef.current) {
            infoWindowRef.current.open(markerRef.current.map, markerRef.current);
        }
    }, []);

    return (
        <GoogleMap mapContainerStyle={containerStyle} center={center} zoom={15}>
            <Marker
                position={center}
                onClick={() => setSelected(center)}
            />
            {selected && (
                <InfoWindow
                    position={selected}
                    onCloseClick={() => setSelected(null)}
                >
                    <div>
                        <h3>{name}</h3>
                    </div>
                </InfoWindow>
            )}
        </GoogleMap>
    );
};

export default GoogleMarker;
