import React, { useState } from "react";
import { CChart } from "@coreui/react-chartjs";
import { Select } from "../Select";
import { monthly, months } from "../../Config/TableStatus";
import { generateNextFiveYears } from "../../Utils/helper";

export const Graph = (props) => {
  const [selectedValue, setSelectedValue] = useState(props.selectedValue);
  const [selectedValueTwo, setSelectedValueTwo] = useState(props.selectedValueTwo);
  const [yearlState, setYearState] = useState(false);

  const handleSelectChange = (e) => {
    const value = e;
    const heading = props.item.heading;
    setSelectedValue(value);
    props.onSelectChange(value, heading);
    if (value === 'yearly') {
      setYearState(true)
    } else {
      setYearState(false)
    }
  };

  const handleSelectChangeTwo = (e) => {
    const value = e;
    setSelectedValueTwo(value);
    props.onSelectYear(value);
  };

  const getCurrentMonth = () => {
    const month = new Date().getMonth() + 1; // getMonth() returns month from 0-11
    return month < 10 ? `0${month}` : month; // Add leading zero if needed
  };
  const years = generateNextFiveYears(); // Generate the next five years


  return (
    <div className="dashCard">
      <div className="d-sm-flex justify-content-between ">
        <h3 className="mainTitle">{props?.item?.heading}</h3>
        <Select
          className="dropdown-graph mainInput w-auto"
          style={props?.style}
          onChange={handleSelectChange}
        >
          {props?.options}
        </Select>
        {yearlState && selectedValue === 'yearly' ?
          <Select
            className="dropdown-graph mainInput"
            onChange={handleSelectChangeTwo}
          >
            {years}
          </Select>
          : selectedValue === 'monthly' ?
            <Select
              className="dropdown-graph mainInput"
              onChange={handleSelectChangeTwo}
              value={getCurrentMonth()}
            >
              {months}
            </Select>
            : ''}

      </div>

      <div className="graph-wrapper">
        <CChart
          type="line"
          height={90} // Changed from string to number
          options={{
            scales: {
              y: {
                suggestedMin: 0,
                suggestedMax: 10,
              },
            },
          }}
          data={{
            labels: props?.label
              ? props?.label
              : [
                "January",
                "February",
                "March",
                "April",
                "May",
                "June",
                "July",
                "August",
                "September",
                "October",
                "November",
                "December",
              ],

            tension: "0.5",
            datasets: [
              {
                label: props?.item?.label,
                fill: false,
                backgroundColor: "#B09A70",
                borderColor: "#B09A70",
                pointBackgroundColor: "#fff",
                borderWidth: 4,
                pointBorderColor: "#B09A70",
                data: props?.item?.data,
                tension: 0.5,
              },
            ],
          }}
        />
      </div>
    </div>
  );
};
