import React, { useState } from 'react';
import Slider from 'react-slick';
import './index.css'
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faAngleLeft, faAngleRight, faHeart as filledHeart } from '@fortawesome/free-solid-svg-icons';


export const ImageSliderMultiple = ({ images, className, productDetailsClass, thumbnailClass }) => {
    const [nav1, setNav1] = useState();
    const [nav2, setNav2] = useState();
    const [checkedIcon, setCheckedIcon] = useState(false);

    const handleCheck = () => setCheckedIcon(!checkedIcon);

    const goToNextSlide = () => {
        if (nav1) {
            nav1.slickNext();
        }
    };

    const goToPrevSlide = () => {
        if (nav1) {
            nav1.slickPrev();
        }
    };

    return (
        <div className={`position-relative user-details-slider ${className ? className : ''}`}>
            <div className="product-slider-buttons">
                <button className='product-prev-btn' onClick={goToPrevSlide}><FontAwesomeIcon icon={faAngleLeft} /></button>
                <button className='product-next-btn' onClick={goToNextSlide}><FontAwesomeIcon icon={faAngleRight} /></button>
            </div>
            <Slider arrows={false} asNavFor={nav2} ref={(slider1) => setNav1(slider1)}>
                {images?.map((ele, index) => (
                    <div key={index} className={`product-detail-img w-100 position-relative ${productDetailsClass ? productDetailsClass : ''}`}>
                        <img src={ele?.path} alt="" className="img-fluid w-100" />
                    </div>
                ))}
            </Slider>
            {/* <Slider
                asNavFor={nav1}
                ref={(slider2) => setNav2(slider2)}
                slidesToShow={3}
                swipeToSlide={true}
                focusOnSelect={true}
                arrows={false}
            >
                {images?.map((ele, index) => (
                    <div key={index} className={`thumbnail-img ${thumbnailClass ? thumbnailClass : ''}`}>
                        <img src={ele?.path} alt="" className="img-fluid w-100 px-2" />
                    </div>
                ))}
            </Slider> */}
        </div>
    )
}
