import React, { useRef, useState } from 'react';
import { images } from '../../Assets';
import './index.css';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faTimes } from '@fortawesome/free-solid-svg-icons';

const ImageUpload = ({ setFieldValue, error, initialImages = [] }) => {
    const [previewImages, setPreviewImages] = useState(initialImages);
    const fileInputRef = useRef(null);

    const handleImageChange = (e) => {
        const files = Array.from(e.target.files);
        const newImages = files.map(file => ({
            file,
            url: URL.createObjectURL(file)
        }));
        setPreviewImages((prevImages) => [...prevImages, ...newImages]);
        setFieldValue('images', [...previewImages, ...newImages.map(image => image.file)]);
    };

    const handleImageClick = (index) => {
        fileInputRef.current.click();
    };

    const handleDeleteImage = (index) => {
        const updatedImages = previewImages.filter((_, i) => i !== index);
        setPreviewImages(updatedImages);
        setFieldValue('images', updatedImages.map(image => image.file)); // Update form value
    };

    const handleUploadMoreClick = () => {
        fileInputRef.current.click();
    };

    return (
        <div className="BannerBoxMain">
            <label className="mainLabel mb-3">Upload Images<span className="red-text">*</span></label>
            <div className="image-grid">
                <div className="BannerBoxMainImg mb-2">
                    <div className="d-flex align-items-center gap-3 flex-wrap">
                        {previewImages.length > 0 && previewImages.map((image, index) => (
                            <div className="position-relative" key={index}>
                                <img
                                    src={image.url}
                                    alt={`Uploaded ${index}`}
                                    className="uploaded preview-img"
                                    onClick={() => handleImageClick(index)}
                                    style={{ cursor: 'pointer' }}
                                />
                                <button
                                    type="button"
                                    className="transparent-btn"
                                    style={{ position: 'absolute', top: 0, right: 0 }}
                                    onClick={() => handleDeleteImage(index)}
                                >
                                    <FontAwesomeIcon icon={faTimes} />
                                </button>
                            </div>
                        ))}
                    </div>
                    <div className="upload-more-btn-container">
                        <button
                            type="button"
                            className="transparent-btn d-flex flex-column text-center"
                            onClick={handleUploadMoreClick}
                        >
                            {previewImages?.length < 1 && (
                                <svg width="95" height="90" viewBox="0 0 95 90" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M71.9922 81.7312C72.7153 81.0187 73.0769 80.175 73.0769 79.2C73.0769 78.225 72.7153 77.3812 71.9922 76.6687C71.269 75.9563 70.4127 75.6 69.4231 75.6C68.4335 75.6 67.5771 75.9563 66.854 76.6687C66.1308 77.3812 65.7692 78.225 65.7692 79.2C65.7692 80.175 66.1308 81.0187 66.854 81.7312C67.5771 82.4437 68.4335 82.8 69.4231 82.8C70.4127 82.8 71.269 82.4437 71.9922 81.7312ZM86.6076 81.7312C87.3307 81.0187 87.6923 80.175 87.6923 79.2C87.6923 78.225 87.3307 77.3812 86.6076 76.6687C85.8844 75.9563 85.028 75.6 84.0385 75.6C83.0489 75.6 82.1925 75.9563 81.4694 76.6687C80.7462 77.3812 80.3846 78.225 80.3846 79.2C80.3846 80.175 80.7462 81.0187 81.4694 81.7312C82.1925 82.4437 83.0489 82.8 84.0385 82.8C85.028 82.8 85.8844 82.4437 86.6076 81.7312ZM93.4014 62.775C94.4671 63.825 95 65.1 95 66.6V84.6C95 86.1 94.4671 87.375 93.4014 88.425C92.3357 89.475 91.0417 90 89.5192 90H5.48077C3.95833 90 2.66426 89.475 1.59856 88.425C0.532853 87.375 0 86.1 0 84.6V66.6C0 65.1 0.532853 63.825 1.59856 62.775C2.66426 61.725 3.95833 61.2 5.48077 60H29.8588C30.6581 63.3 31.9997 65.025 33.8837 66.375C35.7677 67.725 37.8706 68.4 40.1923 68.4H54.8077C57.1294 68.4 59.2323 67.725 61.1163 66.375C63.0003 65.025 64.3419 63.3 65.1412 60H89.5192C91.0417 61.2 92.3357 61.725 93.4014 62.775ZM75.646 26.2688C76.8259 27.3938 77.0923 28.6875 76.4453 30.15C75.7983 31.65 74.6755 32.4 73.0769 32.4H57.9268V57.6C58.4615 58.575 58.1 59.4188 57.3768 60.1312C56.6536 60.8438 55.7973 61.2 54.8077 61.2H40.1923C39.2027 61.2 38.3464 60.8438 37.6232 60.1312C36.9 59.4188 36.5385 58.575 37.0732 57.6V32.4H21.9231C20.3245 32.4 19.2017 31.65 18.5547 30.15C17.9077 28.6875 18.1741 27.3938 19.354 26.2688L44.9309 1.06875C45.616 0.35625 46.4724 0 47.5 0C48.5276 0 49.384 0.35625 50.0691 1.06875L75.646 26.2688Z" fill="#B09A70" />
                                </svg>
                            )}
                            <span className='mt-2'>
                                Upload {previewImages?.length > 0 ? 'More' : 'Images'}
                            </span>
                        </button>
                    </div>
                </div>
            </div>


            <input
                type="file"
                accept="image/*"
                className="btnBlueBG"
                id="profileImageNew"
                onChange={handleImageChange}
                ref={fileInputRef}
                style={{ display: 'none' }}
                multiple
            />

            {error && <div className="errorText red-text">{error}</div>}
        </div>
    );
};

export default ImageUpload;

// import React, { useRef, useState } from 'react';
// import { images } from '../../Assets';
// import './index.css'
// // import { images } from '../../../Assets';
// // import './style.css';

// const ImageUpload = ({ setFieldValue, error, initialImage }) => {
//     const [previewImage, setPreviewImage] = useState(initialImage);
//     const fileInputRef = useRef(null);

//     const handleImageChange = (e) => {
//         const file = e.target.files[0];
//         setPreviewImage(URL.createObjectURL(file));
//         setFieldValue('image', file);
//     };

//     const handleImageClick = () => {
//         fileInputRef.current.click();
//     };

//     return (
//         <div className="BannerBoxMain">
//             <label className="mainLabel mb-3">Upload Image<span className="red-text">*</span></label>
//             <div className={`BannerBoxMainImg ${!previewImage ? 'uploadIcon' : ''} mb-2`}>
//                 {previewImage && (
//                     <img
//                         src={previewImage}
//                         alt="product"
//                         className={`${previewImage ? 'uploaded' : ''} preview-img`}
//                         onClick={previewImage ? handleImageClick : undefined}
//                         style={{ cursor: previewImage ? 'pointer' : 'default' }}
//                     />
//                 )}
//                 {!previewImage && (
//                     <>
//                         <label htmlFor="profileImageNew">
//                             <svg width="95" height="90" viewBox="0 0 95 90" fill="none" xmlns="http://www.w3.org/2000/svg">
//                                 <path d="M71.9922 81.7312C72.7153 81.0187 73.0769 80.175 73.0769 79.2C73.0769 78.225 72.7153 77.3812 71.9922 76.6687C71.269 75.9563 70.4127 75.6 69.4231 75.6C68.4335 75.6 67.5771 75.9563 66.854 76.6687C66.1308 77.3812 65.7692 78.225 65.7692 79.2C65.7692 80.175 66.1308 81.0187 66.854 81.7312C67.5771 82.4437 68.4335 82.8 69.4231 82.8C70.4127 82.8 71.269 82.4437 71.9922 81.7312ZM86.6076 81.7312C87.3307 81.0187 87.6923 80.175 87.6923 79.2C87.6923 78.225 87.3307 77.3812 86.6076 76.6687C85.8844 75.9563 85.028 75.6 84.0385 75.6C83.0489 75.6 82.1925 75.9563 81.4694 76.6687C80.7462 77.3812 80.3846 78.225 80.3846 79.2C80.3846 80.175 80.7462 81.0187 81.4694 81.7312C82.1925 82.4437 83.0489 82.8 84.0385 82.8C85.028 82.8 85.8844 82.4437 86.6076 81.7312ZM93.4014 62.775C94.4671 63.825 95 65.1 95 66.6V84.6C95 86.1 94.4671 87.375 93.4014 88.425C92.3357 89.475 91.0417 90 89.5192 90H5.48077C3.95833 90 2.66426 89.475 1.59856 88.425C0.532853 87.375 0 86.1 0 84.6V66.6C0 65.1 0.532853 63.825 1.59856 62.775C2.66426 61.725 3.95833 61.2 5.48077 60H29.8588C30.6581 63.3 31.9997 65.025 33.8837 66.375C35.7677 67.725 37.8706 68.4 40.1923 68.4H54.8077C57.1294 68.4 59.2323 67.725 61.1163 66.375C63.0003 65.025 64.3419 63.3 65.1412 60H89.5192C91.0417 61.2 92.3357 61.725 93.4014 62.775ZM75.646 26.2688C76.8259 27.3938 77.0923 28.6875 76.4453 30.15C75.7983 31.65 74.6755 32.4 73.0769 32.4H57.9268V57.6C58.4615 58.575 58.1 59.4188 57.3768 60.1312C56.6536 60.8438 55.7973 61.2 54.8077 61.2H40.1923C39.2027 61.2 38.3464 60.8438 37.6232 60.1312C36.9 59.4188 36.5385 58.575 37.0732 57.6V32.4H21.9231C20.3245 32.4 19.2017 31.65 18.5547 30.15C17.9077 28.6875 18.1741 27.3938 19.354 26.2688L44.9309 1.06875C45.616 0.35625 46.4724 0 47.5 0C48.5276 0 49.384 0.35625 50.0691 1.06875L75.646 26.2688Z" fill="#B09A70" />
//                             </svg>
//                             <p className="mb-0 mt-2">Drag & Drop Image</p>

//                         </label>
//                         <div className="d-none">
//                             <input
//                                 type="file"
//                                 accept="image/*"
//                                 className="btnBlueBG"
//                                 id="profileImageNew"
//                                 onChange={handleImageChange}
//                                 ref={fileInputRef}
//                             />
//                         </div>
//                     </>
//                 )}
//                 {previewImage && (
//                     <input
//                         type="file"
//                         accept="image/*"
//                         className="btnBlueBG"
//                         id="profileImageNew"
//                         onChange={handleImageChange}
//                         ref={fileInputRef}
//                         style={{ display: 'none' }}
//                     />
//                 )}

//                 {previewImage && (
//                     <label
//                         htmlFor="files"
//                         className="mb-0 text-center w-100"
//                     >
//                         Click Image to replace or update
//                     </label>
//                 )}
//             </div>


//             {error && <div className="errorText red-text">{error}</div>}
//         </div>
//     );
// };

// export default ImageUpload;
