import { useState } from "react";
import { Link, useNavigate } from "react-router-dom";
import { Formik } from "formik";
import "./style.css";
import CustomInput from "../CustomInput/index.jsx";
import CustomButton from "../CustomButton/index.jsx";
import Toast from "../Toast/index.jsx";
import { useLogin } from "../../Services/Auth.jsx";
import { useFormStatus } from "../../Hooks/useFormStatus.jsx";
import { Form } from "react-bootstrap";
import Cookies from "js-cookie";

const LoginForm = ({
  actor,
  apiEndpoint,
  validationSchema
}) => {
  const navigate = useNavigate();
  const [rememberMeValue, setRememberMeValue] = useState(
    Cookies.get('zekeMartin-em') && Cookies.get('zekeMartin-pd') ? true : false
  );
  const login = useLogin();
  const { isSubmitting, startSubmitting, stopSubmitting } = useFormStatus();
  const handleSubmit = async (values) => {
    if (rememberMeValue) {
      Cookies.set('zekeMartin-em', values.email, { expires: 999 });
      Cookies.set('zekeMartin-pd', values.password, { expires: 999 });
    } else {
      Cookies.remove('zekeMartin-em');
      Cookies.remove('zekeMartin-pd');
    }
    startSubmitting();
    let response = await login(apiEndpoint, values);
    if (response === true) {

      setTimeout(() => {
        navigate(`/${actor}/dashboard`);
      }, 1000);
    }
    stopSubmitting();
  };

  const handleCheckboxChange = (event) => {
    setRememberMeValue(event.target.checked);
  };

  return (
    <Formik
      initialValues={{
        email: Cookies.get('zekeMartin-em') || "",
        password: Cookies.get('zekeMartin-pd') || "",
        rememberMe: rememberMeValue // Sync Formik with the local state
      }}
      validationSchema={validationSchema}
      onSubmit={handleSubmit}
    >
      {({
        values,
        errors,
        touched,
        handleChange,
        handleBlur,
        handleSubmit,
      }) => (
        <form className="mt-3" onSubmit={handleSubmit}>
          <Toast />
          <CustomInput
            label="Email Address"
            id="email"
            type="email"
            placeholder="Enter Email Address"
            labelclass="mainLabel"
            inputclass="mainInput mainInputLogIn"
            value={values.email}
            onChange={handleChange}
            onBlur={handleBlur}
            error={touched.email && errors.email}
          />
          <CustomInput
            label="Password"
            id="password"
            type="password"
            placeholder="Enter Password"
            labelclass="mainLabel"
            inputclass="mainInput mainInputLogIn"
            value={values.password}
            onChange={handleChange}
            onBlur={handleBlur}
            error={touched.password && errors.password}
          />
          <div className="d-flex align-items-baseline justify-content-between mt-1">
            <Form.Check
              type="switch"
              id="custom-switch"
              label="Remember Me"
              checked={rememberMeValue}
              onChange={(event) => {
                handleCheckboxChange(event);
              }}
            />
            <Link
              to={`/${actor}/forget-password`}
              className="fw-light text-decoration-underline whiteColor"
            >
              Forgot Password?
            </Link>
          </div>
          {actor === "restaurant" && (
            <Link
              to={`/${actor}/signup`}
              className="fw-light text-decoration-underline blackColor"
            >
              New Restaurant? Click Here to Register
            </Link>
          )}
          <div className="mt-4 text-center">
            <CustomButton
              className="px-5 w-100 green-btn"
              text="Log In"
              pendingText="Loading..."
              isPending={isSubmitting}
              type="submit"
            />
          </div>
        </form>
      )}
    </Formik>
  );
};

export default LoginForm;
