import React, { useState, useEffect } from "react";

const MapComponent = ({ onLocationChange }) => {
  const [map, setMap] = useState(null);
  const [marker, setMarker] = useState(null);

  useEffect(() => {
    if (!map) return;

    const onClickMap = (event) => {
      const { latLng } = event;
      const lat = latLng.lat();
      const lng = latLng.lng();

      // Create a new advanced marker
      const newMarker = new google.maps.marker.AdvancedMarkerElement({
        map,
        position: { lat, lng },
        draggable: true,
        title: "Pakistan",
      });

      // Remove the previous marker if it exists
      if (marker && typeof marker.setMap === "function") {
        marker.setMap(null);
      }

      // Set the new marker
      setMarker(newMarker);

      // Notify parent component about the location change
      onLocationChange({ lat, lng });
    };

    // Add click event listener to the map
    map.addListener("click", onClickMap);

    return () => {
      // Remove event listener using google.maps.event.removeListener
      google.maps.event.clearListeners(map, "click");
    };
  }, [map, marker, onLocationChange]);

  useEffect(() => {
    if (map && marker) {
      // Center the map on the marker
      map.panTo(marker.position);
    }
  }, [map, marker]);

  useEffect(() => {
    // Initialize the map
    const googleMap = new window.google.maps.Map(
      document.getElementById("map"),
      // lat: 24.8607, lng: 67.0011
      {
        center: { lat: 0, lng: 0 },
        zoom: 5,
        mapId: "286dcdf612d85f84",
      }
    );
    setMap(googleMap);
  }, []);

  return <div id="map" style={{ height: "400px", width: "100%" }}></div>;
};

export default MapComponent;
