import { React } from "react";
import CustomButton from "../CustomButton";
import "./style.css";

const NotificationCard = (props) => {
  const handleClick = () => {
    props.onClick(props?.id); // Call the parent component's handleClick with the notification ID
  };

  return (
    <div
      className={`notificationWrapper ${props.read === null ? "unread" : ""}`}
    >
      <div
        className={`d-sm-flex justify-content-between align-items-center gap-3 `}
        key={props.id}
      >
        <div className="d-flex gap-3 align-items-center">
          <div className="notificationImageIcon">
            <img src={props?.image} alt="Icon" />
          </div>
          <div className="flex-grow-1">
            <div className="d-flex gap-3">
              <h5 className="notificationHeading">{props?.name}</h5>
              <p className="notificationText ps-0">{props?.text}</p>
            </div>
            <div className="dateTime">
              <p className="p-sm l-grey-text mb-0">{props?.date}</p>
              <span className="mx-2">|</span>
              <p className="p-sm l-grey-text mb-0">{props?.time}</p>
            </div>
          </div>
        </div>
        <div className="flex-shrink-0 text-end">
          {props.read === null && (
            <CustomButton
              onClick={handleClick}
              className=""
              text="Mark as Read"
            />
          )}

        </div>
      </div>
    </div>
  );
};

export default NotificationCard;
