import React from "react";
import { Field, ErrorMessage } from "formik";

// A Select component that integrates with Formik
export const FormSelect = ({
    label,
    name,
    options, // Changed from children to options for clarity
    labelclass,
    className,
    style,
    span,
    ...rest
}) => {
    return (
        <>
            <label className={`cap ${labelclass || ""}`}>
                {label}
                {span ? <span className="red-text">*</span> : ""}
            </label>

            <Field as="select"
                className={`mainInput ${className ? className : ''}`}
                style={style}
                name={name}
                {...rest}
            >
                {options.map((item) => (
                    <option key={item.value} value={item.value}>
                        {item.text}
                    </option>
                ))}
            </Field>

            <ErrorMessage name={name}>
                {msg => <div className="error-message">{msg}</div>}
            </ErrorMessage>
        </>
    );
};
