import ReactSelect from "react-select";

export const SelectField = ({ field, form, options, isMulti, ...props }) => {
    const { setFieldValue } = form;

    // Handle change for multi or single select
    const handleChange = (selectedOption) => {
        // If multi, selectedOption will be an array of objects; if single, it will be a single object
        const value = isMulti
            ? selectedOption // For multi, just pass the whole array of selected objects
            : selectedOption?.value ? selectedOption : null; // For single, return the object or null if none selected

        setFieldValue(field.name, value); // Update Formik's field value
    };

    // Map field.value (array of selected objects) to corresponding options
    const selectedValue = isMulti
        ? field.value || []  // Use field.value directly if it's already an array of selected objects
        : field.value ? [field.value] : null;  // For single select, wrap it in an array if it's an object

    return (
        <div>
            <ReactSelect
                {...field}
                {...props}
                isMulti={isMulti}
                options={options}
                value={selectedValue || (isMulti ? [] : null)}  // Default to empty array for multi, or null for single select
                onChange={handleChange}
                className="mainInput"
            />
            {form.touched[field.name] && form.errors[field.name] && (
                <div className="errorText red-text">{form.errors[field.name]}</div>
            )}
        </div>
    );
};
