import React, { useState } from 'react';
import Slider from 'react-slick';
import './index.css';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faAngleLeft, faAngleRight } from '@fortawesome/free-solid-svg-icons';

export const SiteSlider = ({ className, children }) => {
    const [sliderRef, setSliderRef] = useState(null);
    const [checkedIcon, setCheckedIcon] = useState(false);

    const handleCheck = () => setCheckedIcon(!checkedIcon);

    const goToNextSlide = () => {
        sliderRef && sliderRef.slickNext();
    };

    const goToPrevSlide = () => {
        sliderRef && sliderRef.slickPrev();
    };

    const options = {
        dots: false,
        infinite: true,
        speed: 500,
        slidesToShow: 3,
        slidesToScroll: 1,
        responsive: [
            {
                breakpoint: 1200,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 3,
                    infinite: true,
                }
            },
            {
                breakpoint: 992,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 2,
                    initialSlide: 2
                }
            },
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1
                }
            }
        ]
    };

    return (
        <div className={`position-relative ${className || ''}`}>
            <div className="product-slider-buttons">
                <button className='product-prev-btn' onClick={goToPrevSlide}>
                    <FontAwesomeIcon icon={faAngleLeft} />
                </button>
                <button className='product-next-btn' onClick={goToNextSlide}>
                    <FontAwesomeIcon icon={faAngleRight} />
                </button>
            </div>
            <Slider {...options} arrows={false} ref={setSliderRef}>
                {children}
            </Slider>
        </div>
    );
};
