import React, { useState } from 'react';
import Slider from 'react-slick';
import './index.css'
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faAngleLeft, faAngleRight } from '@fortawesome/free-solid-svg-icons';


export const RecentlyViewedProductSlider = (props) => {
    const [nav1, setNav1] = useState();
    const [checkedIcon, setCheckedIcon] = useState(false);

    const handleCheck = () => setCheckedIcon(!checkedIcon);

    const goToNextSlide = () => {
        if (nav1) {
            nav1.slickNext();
        }
    };

    const goToPrevSlide = () => {
        if (nav1) {
            nav1.slickPrev();
        }
    };

    return (
        <div className={`position-relative ${props?.className ? props?.className : ''}`}>
            <div className="product-slider-buttons">
                <button className='product-prev-btn' onClick={goToPrevSlide}><FontAwesomeIcon icon={faAngleLeft} /></button>
                <button className='product-next-btn' onClick={goToNextSlide}><FontAwesomeIcon icon={faAngleRight} /></button>
            </div>

        </div>
    )
}
