import React from "react";

import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faArrowCircleUp,
  faArrowCircleDown,
  faArrowUp,
} from "@fortawesome/free-solid-svg-icons";

import "./style.css";
import { Link } from "react-router-dom";
import { useAuth } from "../../Hooks/useAuth";

const StatsCard = (props) => {
  // const { role } = useAuth();
  return (
    <>
      {/* <Link to={`/${role}${props?.item?.link}`} style={{ textDecoration: 'none' }}> */}
      <div className="statsCard">
        <div className="statsContent d-flex align-items-center gap-3">
          <div className="statsImg">
            <img src={props.item?.image} alt="Card Icon" />
          </div>
          <div className="statsData">
            <h5 className="statsText mb-0 text-capitalize">{props.item?.text}</h5>
            <div className="d-flex align-items-center gap-2">
              <h3 className="semi-bold mb-0">{props.item?.change}</h3>
              {props?.statsChange && (
                <p className="mb-0">
                  {props.item?.increase ? (
                    <FontAwesomeIcon
                      icon={faArrowUp}
                      className="greenColor"
                    />
                  ) : (
                    <FontAwesomeIcon
                      icon={faArrowCircleDown}
                      className="redColor"
                    />
                  )}
                </p>
              )}
            </div>
          </div>
        </div>
      </div>
      {/* </Link> */}
    </>
  );
};

export default StatsCard;
