import React from "react";
import { ToastContainer, toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";

const Toast = () => {
  return (
    <ToastContainer />
  );
};

export const showToast = (message, type) => {
  console.log(`showToast called with message: ${message} and type: ${type}`); // Add logging

  switch (type) {
    case "success":
      toast.success(message, { position: toast.POSITION.TOP_CENTER });
      break;
    case "error":
      toast.error(message, { position: toast.POSITION.TOP_CENTER });
      break;
    case "info":
      toast.info(message, { position: toast.POSITION.TOP_CENTER });
      break;
    default:
      toast(message, { position: toast.POSITION.TOP_CENTER });
  }
};

export default Toast;
