import { useNavigate } from "react-router-dom";
import PropTypes from "prop-types";
import "./style.css";
import { Formik } from "formik";
import CustomInput from "../../CustomInput";
import CustomButton from "../../CustomButton";
import { forgotEmail } from "../../../Config/Validations";
import Toast, { showToast } from "../../Toast";
import { setEmail, usePageTitle } from "../../../Utils/helper";
import { post } from "../../../Services/Api";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import { UserAuthLayout } from "../Layout/Auth";
import { UserLayout } from "../Layout";

const UserStepOne = ({ apiEndpoint, navigateTo }) => {
    const navigate = useNavigate();
    const { isSubmitting, startSubmitting, stopSubmitting } = useFormStatus();
    usePageTitle("Forgot Password");
    const handleSubmit = async (values) => {
        startSubmitting();
        // setTimeout(() => {
        //     navigate(navigateTo);
        // }, 1000);
        setEmail(values);
        let response = await post(apiEndpoint, values);
        if (response.status) {
            showToast(response.message, "success");
            setTimeout(() => {
                navigate(navigateTo);
            }, 1000);
        } else {
            stopSubmitting();
            showToast(response?.errors?.email[0], "error")
        }
        stopSubmitting();
    };

    return (
        <UserLayout>
            <UserAuthLayout
                authTitle="Forgot Password"
                authPara="Enter your email address to receive a verification code"
                backOption={true}
            >
                <Formik
                    initialValues={{ email: "" }}
                    validationSchema={forgotEmail}
                    onSubmit={handleSubmit}
                >
                    {({ values, errors, touched, handleChange, handleBlur, handleSubmit }) => (
                        <form onSubmit={handleSubmit} className="mt-4">
                            <Toast />
                            <CustomInput
                                label="Email Address"
                                id="email"
                                type="email"
                                placeholder="Enter Email Address"
                                labelclass="mainLabel"
                                inputclass="mainInput mainInputLogIn"
                                value={values.email}
                                onChange={handleChange}
                                onBlur={handleBlur}
                                error={touched.email && errors.email}
                            />
                            <div className="mt-4 text-center">
                                <CustomButton
                                    type="submit"
                                    className="w-100 px-5"
                                    text="Continue"
                                    isPending={isSubmitting}
                                    pendingText="Loading..."
                                />
                            </div>
                        </form>
                    )}
                </Formik>
            </UserAuthLayout>
        </UserLayout>
    );
};

UserStepOne.propTypes = {
    apiEndpoint: PropTypes.string.isRequired,
    navigateTo: PropTypes.string.isRequired,
};

export default UserStepOne;
