import { Link, useLocation } from "react-router-dom";
import "./style.css";

export const UserAuthLayout = (props) => {
  const location = useLocation();
  const pathname = location?.pathname;
  const [, firstSegment] = pathname.split("/");

  return (
    <>
      <section className={`login-bg py-sm-5 py-4 ${props?.authClasMain}`}>
        <div className="container">
          <div className="row">
            <div className="col-12">
              <div className="contact-card mx-auto">
                <div className="contact-card-inner">
                  <div className="text-center">
                    <h4 className="heavy semi-bold">{props?.authTitle}</h4>
                    {props?.authPara && (
                      <p className="authPara text-capitalize">{props?.authPara}</p>
                    )}
                  </div>
                  {props?.children}
                  {props?.backOption && (
                    <div className="text-center mt-4">
                      <Link
                        to={`/login`}
                        className="fw-normal text-decoration-underline primaryColor"
                      >
                        Back to Login
                      </Link>
                    </div>
                  )}
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};
