import React, { useState } from "react";
import { Link } from "react-router-dom";
import { images } from "../../../Assets";
import { Button, Form as BootstrapForm, InputGroup } from "react-bootstrap";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faArrowRight } from "@fortawesome/free-solid-svg-icons";
import { Formik, Form, Field, ErrorMessage } from "formik";
import CustomModal from "../../CustomModal";
import { subscribeValidationSchema } from "../../../Config/Validations";
export const UserFooter = () => {

  const [showModalSubscribePopUp, setShowModalSubscribePopUp] = useState(false);
  const [showModal, setShowModal] = useState(false);
  const handleShow = () => setShowModal(true);
  const [showModal2, setShowModal2] = useState(false);
  const handleShow2 = () => setShowModal2(true);
  const onSubmit = (values, { setSubmitting, resetForm }) => {
    console.log("Form data:", values);
    setShowModalSubscribePopUp(true);
    // Do something with the form data (e.g., send it to an API)
    setSubmitting(false);
    resetForm();
  };
  return (
    <>
      <footer>
        <div className="container">
          <div className="footer-inner">
            <div className="row">
              <div className="col-lg-4 pe-xxl-5 pe-lg-4 my-3">
                <Link to={"/"}>
                  <img src={images.logoBlack} alt="" className="img-fluid site-logo" />
                </Link>
                <div className="mxw-360">
                  <p className="mt-3 mb-0">I'd rather die of passion than live with boredom</p>
                  <p className="mb-3">-Vincent Van Gogh</p>
                </div>
              </div>
              <div className="col-lg-8">
                <div className="row">
                  <div className="col-md-3 col-sm-6 my-3">
                    <h6 className="heavy p-md">Quick Links</h6>
                    <ul className="footer-links mt-4">
                      <li>
                        <Link to="/">Home</Link>
                      </li>
                      <li>
                        <Link to="/categories">Bands</Link>
                      </li>
                      <li>
                        <Link to="/about-us">About Us</Link>
                      </li>
                      <li>
                        <Link to="/contact-us">Contact Us</Link>
                      </li>
                      <li>
                        <Link to="/policies">Policies</Link>
                      </li>
                    </ul>
                  </div>
                  <div className="col-md-4 col-sm-6 my-3">
                    <h6 className="heavy p-md">Features</h6>
                    <ul className="footer-links mt-4">
                      <li>
                        {/* <Link to="/new-requests">New Request</Link> */}
                        <Link to="/how-it-works">New Request</Link>
                      </li>
                      <li>
                        <Link onClick={handleShow}>Tap To Match</Link>
                      </li>
                      <li>
                        <Link onClick={handleShow2} to="">Map</Link>
                      </li>
                      <li>
                        <Link to="/safety-features">Safety Features</Link>
                      </li>
                      <li>
                        <Link to="/how-it-works">How It Works</Link>
                      </li>
                    </ul>
                  </div>
                  <div className="col-md-5 col-sm-6 my-3">
                    <h6 className="heavy p-md">Subscribe</h6>
                    <p className="mt-4">Subscribe to get the latest news</p>
                    {/* <InputGroup className="mb-3">
                      <Form.Control
                        placeholder="Email Address"
                        aria-label="Email Address"
                        className="mainInput"
                        aria-describedby="basic-addon2"
                      />
                      <Button variant="outline-secondary" className="newsletter-btn" id="button-addon2">
                        <FontAwesomeIcon icon={faArrowRight} />
                      </Button>
                    </InputGroup> */}
                    <Formik
                      initialValues={{
                        email: "",
                      }}
                      validationSchema={subscribeValidationSchema}
                      onSubmit={onSubmit}
                    >
                      {({ isSubmitting }) => (
                        <Form>
                          <InputGroup className="mb-3">
                            <Field
                              name="email"
                              type="email"
                              placeholder="Email Address"
                              aria-label="Email Address"
                              className="mainInput form-control"
                              aria-describedby="button-addon2"
                            />
                            <Button
                              type="submit"
                              variant="outline-secondary"
                              className="newsletter-btn"
                              id="button-addon2"
                              disabled={isSubmitting}
                            >
                              <FontAwesomeIcon icon={faArrowRight} />
                            </Button>
                          </InputGroup>
                          {/* Error message for email */}
                          <ErrorMessage
                            name="email"
                            component="div"
                            className="text-danger mb-2"
                          />
                        </Form>
                      )}
                    </Formik>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div className="row">
            <div className="col-12">
              <div className="py-3 d-flex align-items-center justify-content-between">
                <p className="mb-0">
                  &copy;Copyright Banded. All rights reserved.
                </p>
                <div className="d-flex align-items-center gap-3">
                  <a target="_blank" href="https://www.instagram.com/bandeddating/?hl=en">
                    <svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="30" height="30" viewBox="0 0 50 50">
                      <path d="M 16 3 C 8.8324839 3 3 8.8324839 3 16 L 3 34 C 3 41.167516 8.8324839 47 16 47 L 34 47 C 41.167516 47 47 41.167516 47 34 L 47 16 C 47 8.8324839 41.167516 3 34 3 L 16 3 z M 16 5 L 34 5 C 40.086484 5 45 9.9135161 45 16 L 45 34 C 45 40.086484 40.086484 45 34 45 L 16 45 C 9.9135161 45 5 40.086484 5 34 L 5 16 C 5 9.9135161 9.9135161 5 16 5 z M 37 11 A 2 2 0 0 0 35 13 A 2 2 0 0 0 37 15 A 2 2 0 0 0 39 13 A 2 2 0 0 0 37 11 z M 25 14 C 18.936712 14 14 18.936712 14 25 C 14 31.063288 18.936712 36 25 36 C 31.063288 36 36 31.063288 36 25 C 36 18.936712 31.063288 14 25 14 z M 25 16 C 29.982407 16 34 20.017593 34 25 C 34 29.982407 29.982407 34 25 34 C 20.017593 34 16 29.982407 16 25 C 16 20.017593 20.017593 16 25 16 z"></path>
                    </svg>
                  </a>
                  <a target="_blank" href="https://www.tiktok.com/@bandeddating">
                    <svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="30" height="30" viewBox="0 0 50 50">
                      <path d="M 9 4 C 6.2495759 4 4 6.2495759 4 9 L 4 41 C 4 43.750424 6.2495759 46 9 46 L 41 46 C 43.750424 46 46 43.750424 46 41 L 46 9 C 46 6.2495759 43.750424 4 41 4 L 9 4 z M 9 6 L 41 6 C 42.671576 6 44 7.3284241 44 9 L 44 41 C 44 42.671576 42.671576 44 41 44 L 9 44 C 7.3284241 44 6 42.671576 6 41 L 6 9 C 6 7.3284241 7.3284241 6 9 6 z M 26.042969 10 A 1.0001 1.0001 0 0 0 25.042969 10.998047 C 25.042969 10.998047 25.031984 15.873262 25.021484 20.759766 C 25.016184 23.203017 25.009799 25.64879 25.005859 27.490234 C 25.001922 29.331679 25 30.496833 25 30.59375 C 25 32.409009 23.351421 33.892578 21.472656 33.892578 C 19.608867 33.892578 18.121094 32.402853 18.121094 30.539062 C 18.121094 28.675273 19.608867 27.1875 21.472656 27.1875 C 21.535796 27.1875 21.663054 27.208245 21.880859 27.234375 A 1.0001 1.0001 0 0 0 23 26.240234 L 23 22.039062 A 1.0001 1.0001 0 0 0 22.0625 21.041016 C 21.906673 21.031216 21.710581 21.011719 21.472656 21.011719 C 16.223131 21.011719 11.945313 25.289537 11.945312 30.539062 C 11.945312 35.788589 16.223131 40.066406 21.472656 40.066406 C 26.72204 40.066409 31 35.788588 31 30.539062 L 31 21.490234 C 32.454611 22.653646 34.267517 23.390625 36.269531 23.390625 C 36.542588 23.390625 36.802305 23.374442 37.050781 23.351562 A 1.0001 1.0001 0 0 0 37.958984 22.355469 L 37.958984 17.685547 A 1.0001 1.0001 0 0 0 37.03125 16.6875 C 33.886609 16.461891 31.379838 14.012216 31.052734 10.896484 A 1.0001 1.0001 0 0 0 30.058594 10 L 26.042969 10 z M 27.041016 12 L 29.322266 12 C 30.049047 15.2987 32.626734 17.814404 35.958984 18.445312 L 35.958984 21.310547 C 33.820114 21.201935 31.941489 20.134948 30.835938 18.453125 A 1.0001 1.0001 0 0 0 29 19.003906 L 29 30.539062 C 29 34.707538 25.641273 38.066406 21.472656 38.066406 C 17.304181 38.066406 13.945312 34.707538 13.945312 30.539062 C 13.945312 26.538539 17.066083 23.363182 21 23.107422 L 21 25.283203 C 18.286416 25.535721 16.121094 27.762246 16.121094 30.539062 C 16.121094 33.483274 18.528445 35.892578 21.472656 35.892578 C 24.401892 35.892578 27 33.586491 27 30.59375 C 27 30.64267 27.001859 29.335571 27.005859 27.494141 C 27.009759 25.65271 27.016224 23.20692 27.021484 20.763672 C 27.030884 16.376775 27.039186 12.849206 27.041016 12 z"></path>
                    </svg>
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </footer >
      <CustomModal
        show={showModal}
        close={() => setShowModal(false)}
        success
        heading="For Tap To Match, you have to open the app to connect with people."
      />
      <CustomModal
        show={showModalSubscribePopUp}
        close={() => setShowModalSubscribePopUp(false)}
        success
        heading="Subscribed successfully."
      />
      <CustomModal
        show={showModal2}
        close={() => setShowModal2(false)}
        success
        heading="For Map, you have to open the app."
      />
    </>
  );
};
