import React, { useEffect, useState } from "react";
import { Col, Container, Dropdown, Nav, Navbar, Row } from "react-bootstrap";
import { Link, NavLink, useLocation, useNavigate } from "react-router-dom";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faBars, faCartShopping, faHeart, faShoppingBag, faSignOut, faUser } from "@fortawesome/free-solid-svg-icons";
import { images } from "../../../Assets";
import { useAuth } from "../../../Hooks/useAuth";
import { useLogout } from "../../../Services/Auth";
import { notificationsData } from "../../../Config/data";
import { showToast } from "../../Toast";
import CustomModal from "../../CustomModal";
import UserHeaderNotification from "../UserHeaderNotification";
import SearchBar from "../SearchBar/SearchBar";
import { useSelector } from "react-redux";
import { getAll } from "../../../Services/Api";

export const UserHeader = React.memo((props) => {
  const navigate = useNavigate();
  const [showModalSuccess, setShowModalSuccess] = useState(false);
  const location = useLocation();
  const { role, user } = useAuth();
  const handleLogout = useLogout();
  const [showModal, setShowModal] = useState(false);
  const [notificationData, setNotificationData] = useState([]);
  const cartItems = useSelector(state => state.cart.items)

  const getNotification = async () => {
    let url = `/${role}/notification/all/list`;
    const response = await getAll(url);
    if (response) {
      setNotificationData(response?.data);
    }
  };
  useEffect(() => {
    if (user, role === 'user') {
      getNotification()
    }
  }, []);
  useEffect(() => {
    // Check if we received the flash message via location state
    const { status } = location.state || {};
    console.log("status", status);

    if (status === 'Payment Successful!') {
      setShowModalSuccess(true);  // Show modal on successful payment
    }
  }, [location.state]);
  const logout = async () => {
    showToast("Logout Successfully", "success");
    await handleLogout(role);
    setTimeout(() => {
      navigate(`/login`);
    }, 1000);
  };

  return (
    <>
      <div className="header-topbar py-2">
        <Container>
          <Row>
            <Col xs={12}>
              <div className="d-flex align-items-center gap-3 justify-content-end">
                <p className="mb-0">Follow Us On:</p>
                <div className="d-flex align-items-center gap-3">
                  <a target="_blank" href="https://www.instagram.com/bandeddating/?hl=en">
                    <svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="30" height="30" viewBox="0 0 50 50">
                      <path d="M 16 3 C 8.8324839 3 3 8.8324839 3 16 L 3 34 C 3 41.167516 8.8324839 47 16 47 L 34 47 C 41.167516 47 47 41.167516 47 34 L 47 16 C 47 8.8324839 41.167516 3 34 3 L 16 3 z M 16 5 L 34 5 C 40.086484 5 45 9.9135161 45 16 L 45 34 C 45 40.086484 40.086484 45 34 45 L 16 45 C 9.9135161 45 5 40.086484 5 34 L 5 16 C 5 9.9135161 9.9135161 5 16 5 z M 37 11 A 2 2 0 0 0 35 13 A 2 2 0 0 0 37 15 A 2 2 0 0 0 39 13 A 2 2 0 0 0 37 11 z M 25 14 C 18.936712 14 14 18.936712 14 25 C 14 31.063288 18.936712 36 25 36 C 31.063288 36 36 31.063288 36 25 C 36 18.936712 31.063288 14 25 14 z M 25 16 C 29.982407 16 34 20.017593 34 25 C 34 29.982407 29.982407 34 25 34 C 20.017593 34 16 29.982407 16 25 C 16 20.017593 20.017593 16 25 16 z"></path>
                    </svg>
                  </a>
                  <a target="_blank" href="https://www.tiktok.com/@bandeddating">
                    <svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="30" height="30" viewBox="0 0 50 50">
                      <path d="M 9 4 C 6.2495759 4 4 6.2495759 4 9 L 4 41 C 4 43.750424 6.2495759 46 9 46 L 41 46 C 43.750424 46 46 43.750424 46 41 L 46 9 C 46 6.2495759 43.750424 4 41 4 L 9 4 z M 9 6 L 41 6 C 42.671576 6 44 7.3284241 44 9 L 44 41 C 44 42.671576 42.671576 44 41 44 L 9 44 C 7.3284241 44 6 42.671576 6 41 L 6 9 C 6 7.3284241 7.3284241 6 9 6 z M 26.042969 10 A 1.0001 1.0001 0 0 0 25.042969 10.998047 C 25.042969 10.998047 25.031984 15.873262 25.021484 20.759766 C 25.016184 23.203017 25.009799 25.64879 25.005859 27.490234 C 25.001922 29.331679 25 30.496833 25 30.59375 C 25 32.409009 23.351421 33.892578 21.472656 33.892578 C 19.608867 33.892578 18.121094 32.402853 18.121094 30.539062 C 18.121094 28.675273 19.608867 27.1875 21.472656 27.1875 C 21.535796 27.1875 21.663054 27.208245 21.880859 27.234375 A 1.0001 1.0001 0 0 0 23 26.240234 L 23 22.039062 A 1.0001 1.0001 0 0 0 22.0625 21.041016 C 21.906673 21.031216 21.710581 21.011719 21.472656 21.011719 C 16.223131 21.011719 11.945313 25.289537 11.945312 30.539062 C 11.945312 35.788589 16.223131 40.066406 21.472656 40.066406 C 26.72204 40.066409 31 35.788588 31 30.539062 L 31 21.490234 C 32.454611 22.653646 34.267517 23.390625 36.269531 23.390625 C 36.542588 23.390625 36.802305 23.374442 37.050781 23.351562 A 1.0001 1.0001 0 0 0 37.958984 22.355469 L 37.958984 17.685547 A 1.0001 1.0001 0 0 0 37.03125 16.6875 C 33.886609 16.461891 31.379838 14.012216 31.052734 10.896484 A 1.0001 1.0001 0 0 0 30.058594 10 L 26.042969 10 z M 27.041016 12 L 29.322266 12 C 30.049047 15.2987 32.626734 17.814404 35.958984 18.445312 L 35.958984 21.310547 C 33.820114 21.201935 31.941489 20.134948 30.835938 18.453125 A 1.0001 1.0001 0 0 0 29 19.003906 L 29 30.539062 C 29 34.707538 25.641273 38.066406 21.472656 38.066406 C 17.304181 38.066406 13.945312 34.707538 13.945312 30.539062 C 13.945312 26.538539 17.066083 23.363182 21 23.107422 L 21 25.283203 C 18.286416 25.535721 16.121094 27.762246 16.121094 30.539062 C 16.121094 33.483274 18.528445 35.892578 21.472656 35.892578 C 24.401892 35.892578 27 33.586491 27 30.59375 C 27 30.64267 27.001859 29.335571 27.005859 27.494141 C 27.009759 25.65271 27.016224 23.20692 27.021484 20.763672 C 27.030884 16.376775 27.039186 12.849206 27.041016 12 z"></path>
                    </svg>
                  </a>
                </div>
              </div>
            </Col>
          </Row>
        </Container>
      </div>
      <header className={`user-header ${props.className}`}>
        <Container>
          <Row>
            <Col xs={12}>
              <Navbar expand="lg">
                <Navbar.Brand>
                  <Link to="/">
                    <img src={images.logoBlack} alt="" className="img-fluid site-logo" />
                  </Link>
                </Navbar.Brand>
                <Navbar.Toggle aria-controls="navbarScroll" className="notButton secondaryColor">
                  <FontAwesomeIcon icon={faBars} />
                </Navbar.Toggle>
                <Navbar.Collapse id="navbarScroll">
                  <Nav className="align-items-lg-center ps-lg-5 align-items-start">
                    {[
                      { path: '/', name: "Home" },
                      { path: '/categories', name: 'Bands' },
                      { path: '/about-us', name: 'About Us' },
                      { path: '/how-it-works', name: 'How It Works' },
                      { path: '/safety-features', name: 'Safety Features' },
                      { path: '/faqs', name: 'FAQs' },
                      { path: '/contact-us', name: 'Contact Us' }].map((path, index) => (
                        <NavLink key={index} className={({ isActive }) => (isActive ? "red-text" : "")} to={path.path}>
                          {path.name}
                        </NavLink>
                      ))}
                  </Nav>

                  <Nav className="align-items-lg-center mt-3 gap-3 mt-lg-0 ms-auto align-items-start">

                    {role === 'user' ? (
                      <div className="d-flex align-items-center gap-3">
                        <UserHeaderNotification notificationData={notificationData} />
                        <Link to="/cart"><FontAwesomeIcon icon={faCartShopping} />{cartItems?.length}</Link>
                        <Dropdown className="userDropdown">
                          <Dropdown.Toggle variant="transparent" className="notButton p-0 toggleButton">
                            <div className="userImage">
                              <img src={user?.image_url} alt="" className="img-fluid" />
                            </div>
                          </Dropdown.Toggle>
                          <Dropdown.Menu className="userMenu" align="end">
                            <Link className="userMenuItem" to="/profile">
                              <FontAwesomeIcon className="me-2 yellow-text" icon={faUser} /> My Profile
                            </Link>
                            {/* <Link className="userMenuItem" to="/wishlist">
                              <FontAwesomeIcon className="me-2 yellow-text" icon={faHeart} /> My Wishlist
                            </Link>
                            <Link className="userMenuItem" to="/my-orders">
                              <FontAwesomeIcon className="me-2 yellow-text" icon={faShoppingBag} /> My Orders
                            </Link> */}
                            <Link onClick={() => setShowModal(true)} className="userMenuItem">
                              <FontAwesomeIcon className="me-1 yellow-text" icon={faSignOut} /> Logout
                            </Link>
                          </Dropdown.Menu>
                        </Dropdown>
                      </div>
                    ) : (
                      <>
                        <Link to="/cart"><FontAwesomeIcon icon={faCartShopping} />{cartItems?.length}</Link>
                        <Link className="secondaryColor" to="/register">Register</Link>
                        <Link className="site-btn py-2" to="/login">Login</Link>
                      </>
                    )}
                  </Nav>
                </Navbar.Collapse>
              </Navbar>
            </Col>
          </Row>
        </Container>
      </header>
      <CustomModal
        show={showModalSuccess}
        close={() => {
          setShowModalSuccess(false);
          navigate('/');  // Navigate to homepage or another route after modal close
        }}
        success
        heading="Order has been placed successfully"
      />
      <CustomModal
        show={showModal}
        close={() => setShowModal(false)}
        action={() => {
          logout();
          setShowModal(false);
        }}
        heading="Are you sure you want to logout?"
      />
    </>
  );
});

// Setting the display name for the component
UserHeader.displayName = "UserHeader";

export default UserHeader;
