import React from 'react';
import './index.css'
import { images } from "../../../Assets";

const ProfileCard = ({ image_url, full_name, age, address, className, ring, gender }) => {
  return (
    <div className={`profile-card ${className ? className : ''}${ring === "white" ? ' white-profile-card' : ring === "tan" ? ' tan-profile-card' : ''}`}>
      <img src={image_url ? image_url : images.noImageFound} alt="" className="img-fluid w-100 profile-card-immg" />
      <div className="profile-card-inner">
        <p className="p-md bold mb-0 gilroy">{full_name}</p>
        <p className="mb-0">{age}, {address}</p>
      </div>
    </div>
  );
}

export default ProfileCard;
