import { faStar } from '@fortawesome/free-solid-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import React from 'react';
import './index.css'
import { dateFormat } from '../../../Utils/helper';

const UserReviewCard = ({ rating, user, created_at, review }) => {
  console.log(user);

  return (
    <div className='review-card mt-3'>
      <div className="d-flex">
        {[1, 2, 3, 4, 5].slice(0, rating).map((item) => (
          <FontAwesomeIcon icon={faStar} key={item} className='yellowColor' />
        ))}
        {[1, 2, 3, 4, 5].slice(0, 5 - rating).map((item) => (
          <FontAwesomeIcon icon={faStar} key={item} className='greyColor' />
        ))}
      </div>
      <div className="d-flex mt-3 align-items-center gap-3 justify-content-between">
        <p className="bold mb-0">{user?.full_name}</p>
        <p className="mb-0">{dateFormat(created_at)}</p>
      </div>
      <p className="secondaryText mt-2 text-secondary">{review}</p>
    </div>
  );
}

export default UserReviewCard;
