import React, { useState } from 'react';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faSearch } from '@fortawesome/free-solid-svg-icons';
import SiteInput from '../../Input/input';

const SearchBar = () => {
    const [searchVisible, setSearchVisible] = useState(false); // State to manage search visibility
    const [searchQuery, setSearchQuery] = useState(''); // State to manage search input

    // Toggle the search bar visibility
    const toggleSearch = () => {
        setSearchVisible(!searchVisible);
    };

    // Handle the input change event
    const handleInputChange = (e) => {
        setSearchQuery(e.target.value);
    };

    return (
        <div className='position-relative'>
            <div className="search-toggle d-lg-block d-none" style={{ cursor: 'pointer' }} onClick={toggleSearch}>
                <FontAwesomeIcon icon={faSearch} />
            </div>

            {/* Show the search input only if searchVisible is true */}
            <div className={`search-barr ${searchVisible? 'd-block': 'd-none'}`}>
                <FontAwesomeIcon icon={faSearch} className="left-icon" />
                <SiteInput
                    className="mainInput ps-5"
                    placeholder="Search"
                    value={searchQuery}
                    onChange={handleInputChange} // Pass the onChange handler
                />
            </div>
        </div>
    );
};

export default SearchBar;