import React, { useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faStar } from "@fortawesome/free-solid-svg-icons";
import { faStar as faStarOutline } from "@fortawesome/free-regular-svg-icons";

const StarRating = ({ totalStars = 5, initialRating = 0, onRatingChange }) => {
  const [rating, setRating] = useState(initialRating);
  const [hoverRating, setHoverRating] = useState(0);

  const handleClick = (ratingValue) => {
    setRating(ratingValue);
    onRatingChange && onRatingChange(ratingValue);
  };

  const handleMouseOver = (ratingValue) => {
    setHoverRating(ratingValue);
  };

  const handleMouseOut = () => {
    setHoverRating(0);
  };

  return (
    <div className="star-rating">
      {Array.from({ length: totalStars }, (_, index) => {
        const starValue = index + 1;
        return (
          <FontAwesomeIcon
            key={index}
            icon={starValue <= (hoverRating || rating) ? faStar : faStarOutline}
            onClick={() => handleClick(starValue)}
            onMouseOver={() => handleMouseOver(starValue)}
            onMouseOut={handleMouseOut}
            className="star"
            style={{ cursor: "pointer", color: starValue <= (hoverRating || rating) ? "#ffc107" : "#e4e5e9" }}
          />
        );
      })}
    </div>
  );
};

export default StarRating;
