import React from 'react';
import { Dropdown } from 'react-bootstrap';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faBell } from '@fortawesome/free-solid-svg-icons';
import { Link } from 'react-router-dom';
import PropTypes from 'prop-types';
import { dateFormat, humanReadable } from '../../../Utils/helper';
import { useAuth } from '../../../Hooks/useAuth';

const UserHeaderNotification = ({ notificationData, getNotification }) => {
    const { role } = useAuth();

    return (
        <Dropdown className="notiDropdown me-2" >
            <Dropdown.Toggle variant="transparent" className="notButton whiteColor">
                <FontAwesomeIcon className="bellIcon" icon={faBell} />
            </Dropdown.Toggle>
            <Dropdown.Menu className="notiMenu" align="end">
                <div className="notificationsBody">
                    {notificationData.slice(0, 5).map((notification) => (
                        <Link
                            className="singleNoti"
                            to={`/notifications`}
                            key={notification.id} // Use a unique key here
                        >
                            <div className="singleNotiIcon">
                                <FontAwesomeIcon className="notiIcon" icon={faBell} />
                            </div>
                            <div className="singleNotiContent">
                                <h5 className="notiHeading">{notification?.title}</h5>
                                <p className="notiText">{notification?.body}</p>
                                <p className="notiDateTime">
                                    {dateFormat(notification?.created_at)} |{" "}
                                    {humanReadable(notification?.created_at)}
                                </p>
                            </div>
                        </Link>
                    ))}
                </div>
                <div className="notiFooter">
                    <Link to={`/notifications`}>View All</Link>
                </div>
            </Dropdown.Menu>
        </Dropdown>
    );
};

UserHeaderNotification.propTypes = {
    notificationData: PropTypes.array.isRequired,
    getNotification: PropTypes.func.isRequired,
};

export default UserHeaderNotification;
