import { useState } from "react";
import { Link, useNavigate } from "react-router-dom";
import { Formik } from "formik";
import "./style.css";
import { Form } from "react-bootstrap";
import Cookies from "js-cookie";
import Toast from "../../Toast";
import CustomInput from "../../CustomInput";
import CustomButton from "../../CustomButton";
import { useLogin } from "../../../Services/Auth";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import { useDispatch } from "react-redux";
import { addMultipleToCart, addToCart, clearCart } from "../../../Store/actions/cartActions";
import { getAll } from "../../../Services/Api";
import { useAuth } from "../../../Hooks/useAuth";

const UserLoginForm = ({
  actor,
  apiEndpoint,
  validationSchema,
}) => {
  const [rememberMeValue, setRememberMeValue] = useState(
    Cookies.get('zekeMartin-user-em') && Cookies.get('zekeMartin-user-pd') ? true : false
  );

  const [load, setLoad] = useState(false);
  const navigate = useNavigate();
  const login = useLogin();
  const { isSubmitting, startSubmitting, stopSubmitting } = useFormStatus(); // use your custom hook


  const handleSubmit = async (values) => {
    startSubmitting();
    if (rememberMeValue) {
      console.log("rememberMeValue", rememberMeValue);

      Cookies.set('zekeMartin-user-em', values.email, { expires: 999 });
      Cookies.set('zekeMartin-user-pd', values.password, { expires: 999 });
    } else {
      Cookies.remove('zekeMartin-user-em');
      Cookies.remove('zekeMartin-user-pd');
    }
    let response = await login(apiEndpoint, values); // open this whn using backend api
    if (response.status) {
      console.log("res", response);

      // if (rememberMeValue) {
      //   console.log("rememberMeValue", rememberMeValue);

      //   Cookies.set('zekeMartin-user-em', values.email, { expires: 999 });
      //   Cookies.set('zekeMartin-user-pd', values.password, { expires: 999 });
      // } else {
      //   Cookies.remove('zekeMartin-user-em');
      //   Cookies.remove('zekeMartin-user-pd');
      // }
      setTimeout(() => {
        navigate(`/`);
      }, 1000);
    }
    stopSubmitting();
  };

  const handleCheckboxChange = (event) => {
    setRememberMeValue(event.target.checked);
  };

  return (
    <Formik
      initialValues={{
        email: Cookies.get('zekeMartin-user-em') || "",
        password: Cookies.get('zekeMartin-user-pd') || "",
        rememberMe: rememberMeValue // Sync Formik with the local state
      }}
      validationSchema={validationSchema}
      onSubmit={handleSubmit}
    >
      {({
        values,
        errors,
        touched,
        handleChange,
        handleBlur,
        handleSubmit,
      }) => (
        <form className="mt-3" onSubmit={handleSubmit}>
          <Toast />
          <CustomInput
            label="Email Address"
            id="email"
            type="email"
            placeholder="Enter Email Address"
            labelclass="mainLabel"
            inputclass="mainInput mainInputLogIn"
            value={values.email}
            onChange={handleChange}
            onBlur={handleBlur}
            error={touched.email && errors.email}
          />
          <CustomInput
            label="Password"
            id="password"
            type="password"
            placeholder="Enter Password"
            labelclass="mainLabel"
            inputclass="mainInput mainInputLogIn"
            value={values.password}
            onChange={handleChange}
            onBlur={handleBlur}
            error={touched.password && errors.password}
          />
          <div className="d-flex align-items-baseline justify-content-between mt-1">
            <Form.Check
              type="switch"
              id="custom-switch"
              label="Remember Me"
              checked={rememberMeValue}
              onChange={(event) => {
                handleCheckboxChange(event);
              }}
            />
            <Link
              to={`/forget-password`}
              className="fw-light text-decoration-underline secondaryColor"
            >
              Forgot Password?
            </Link>
          </div>
          <div className="mt-4 text-center">
            <CustomButton
              className="px-5 green-btn"
              text="Log In"
              pendingText="Loading..."
              isPending={isSubmitting}
              type="submit"
            />
          </div>
          <div className="mt-3 d-flex justify-content-center align-items-center gap-1">
            <p className="mb-0">Not a user?</p>
            <Link to={'/register'} className="secondaryColor">Register Now</Link>
          </div>
        </form>
      )}
    </Formik>
  );
};

export default UserLoginForm;
