import * as Yup from "yup";


// export const ShippingValidationSchema = Yup.object().shape({
//   useDifferentBillingAddress: Yup.boolean(),

//   contactInfo: Yup.object().shape({
//     first_name: Yup.string().required("First name is required"),
//     last_name: Yup.string().required("Last name is required"),
//     email: Yup.string().email("Invalid email").required("Email is required"),
//     phone: Yup.string().required("Phone number is required"),
//   }),

//   shippingAddress: Yup.object().shape({
//     first_name: Yup.string().required("First name is required"),
//     last_name: Yup.string().required("Last name is required"),
//     address: Yup.string().required("Address is required"),
//     phone: Yup.string().required("Phone number is required"),
//     country: Yup.string().required("Country is required"),
//     state: Yup.string().required("State is required"),
//     city: Yup.string().required("City is required"),
//     zip_code: Yup.string().required("Zip Code is required"),
//   }),

//   billingAddress: Yup.object().shape({
//     first_name: Yup.string().test(
//       'billing-first-name',
//       'First name is required',
//       function (value) {
//         return this.parent.useDifferentBillingAddress ? !!value : true;
//       }
//     ),
//     last_name: Yup.string().test(
//       'billing-last-name',
//       'Last name is required',
//       function (value) {
//         return this.parent.useDifferentBillingAddress ? !!value : true;
//       }
//     ),
//     address: Yup.string().test(
//       'billing-address',
//       'Address is required',
//       function (value) {
//         return this.parent.useDifferentBillingAddress ? !!value : true;
//       }
//     ),
//     phone: Yup.string().test(
//       'billing-phone',
//       'Phone number is required',
//       function (value) {
//         return this.parent.useDifferentBillingAddress ? !!value : true;
//       }
//     ),
//     country: Yup.string().test(
//       'billing-country',
//       'Country is required',
//       function (value) {
//         return this.parent.useDifferentBillingAddress ? !!value : true;
//       }
//     ),
//     state: Yup.string().test(
//       'billing-state',
//       'State is required',
//       function (value) {
//         return this.parent.useDifferentBillingAddress ? !!value : true;
//       }
//     ),
//     city: Yup.string().test(
//       'billing-city',
//       'City is required',
//       function (value) {
//         return this.parent.useDifferentBillingAddress ? !!value : true;
//       }
//     ),
//     zip_code: Yup.string().test(
//       'billing-zip',
//       'Zip Code is required',
//       function (value) {
//         return this.parent.useDifferentBillingAddress ? !!value : true;
//       }
//     ),
//   }),
// });
export const ShippingValidationSchema = Yup.object().shape({
  useDifferentBillingAddress: Yup.boolean(),

  contactInfo: Yup.object().shape({
    first_name: Yup.string().required("First name is required"),
    last_name: Yup.string().required("Last name is required"),
    email: Yup.string().email("Invalid email").required("Email is required"),
    phone: Yup.string().required("Phone number is required"),
  }),

  shippingAddress: Yup.object().shape({
    first_name: Yup.string().required("First name is required"),
    last_name: Yup.string().required("Last name is required"),
    address: Yup.string().required("Address is required"),
    phone: Yup.string().required("Phone number is required"),
    country: Yup.string().required("Country is required"),
    state: Yup.string().required("State is required"),
    city: Yup.string().required("City is required"),
    zip_code: Yup.string().required("Zip Code is required"),
  }),

  billingAddress: Yup.object().shape({
    first_name: Yup.string().when('useDifferentBillingAddress', {
      is: false,
      then: Yup.string().required('First name is required'),
    }),
    last_name: Yup.string().when('useDifferentBillingAddress', {
      is: true,
      then: Yup.string().required('Last name is required'),
    }),
    address: Yup.string().when('useDifferentBillingAddress', {
      is: true,
      then: Yup.string().required('Address is required'),
    }),
    phone: Yup.string().when('useDifferentBillingAddress', {
      is: true,
      then: Yup.string().required('Phone number is required'),
    }),
    country: Yup.string().when('useDifferentBillingAddress', {
      is: true,
      then: Yup.string().required('Country is required'),
    }),
    state: Yup.string().when('useDifferentBillingAddress', {
      is: true,
      then: Yup.string().required('State is required'),
    }),
    city: Yup.string().when('useDifferentBillingAddress', {
      is: true,
      then: Yup.string().required('City is required'),
    }),
    zip_code: Yup.string().when('useDifferentBillingAddress', {
      is: true,
      then: Yup.string().required('Zip Code is required'),
    }),
  }),
});
export const pushNotificationSchema = Yup.object().shape({
  title: Yup.string().required("Title is required"),
  message: Yup.string().required("Message is required"),
});

export const subscribeValidationSchema = Yup.object({
  email: Yup.string()
    .email("Invalid email address")
    .required("Email is required"),
});
export const addCategorySchema = Yup.object().shape({
  name: Yup.string().required("Name is required"),
  status: Yup.string().required("Status is required"),
  image: Yup.mixed()
    .required("Image is required")
    .test("fileSize", "Image size should not exceed 10 MB", value => value && value.size <= 1024 * 1024 * 10) // Limit file size to 5MB
    .test("fileType", "Unsupported File Format", value => value && ['image/jpeg', 'image/png'].includes(value.type)), // Allow only specific file types
});
export const updateCategorySchema = Yup.object().shape({
  name: Yup.string().required("Name is required"),
  status: Yup.string().required("Status is required"),
  image: Yup.mixed()
    .notRequired() // Ensure the image field is optional
    .test("fileSize", "Image size should not exceed 10 MB", value => !value || (value.size <= 1024 * 1024 * 10)) // Limit file size to 5MB if image is provided
    .test("fileType", "Unsupported File Format", value => !value || ['image/jpeg', 'image/png'].includes(value.type)) // Allow only specific file types if image is provided
});
export const addBannerSchema = Yup.object().shape({
  title: Yup.string().required("Title is required"),
  expiry_date: Yup.date()
    .required("Expiry date is required")
    .min(new Date(), "Expiry date must be in the future"),
  image: Yup.mixed()
    .required("Image is required")
    .test("fileSize", "Image size should not exceed 10 MB", value => value && value.size <= 1024 * 1024 * 10) // Limit file size to 5MB
    .test("fileType", "Unsupported File Format", value => value && ['image/jpeg', 'image/png'].includes(value.type)), // Allow only specific file types
});
export const addEventSchema = Yup.object().shape({
  name: Yup.string().required("Event Name is required"),
  date: Yup.date()
    .required("Event date is required"),
  // .min(new Date(), "Expiry date must be in the future"),
  address: Yup.string().required("Address is required"),
  image: Yup.mixed()
    .required("Image is required")
    .test("fileSize", "Image size should not exceed 10 MB", value => value && value.size <= 1024 * 1024 * 10) // Limit file size to 5MB
    .test("fileType", "Unsupported File Format", value => value && ['image/jpeg', 'image/png'].includes(value.type)), // Allow only specific file types

});

export const updateBannerSchema = Yup.object().shape({
  title: Yup.string().required("Title is required"),
  expiry_date: Yup.date()
    .required("Expiry date is required")
    .min(new Date(), "Expiry date must be in the future"),
  image: Yup.mixed()
    .notRequired() // Ensure the image field is optional
    .test("fileSize", "Image size should not exceed 10 MB", value => !value || (value.size <= 1024 * 1024 * 10)) // Limit file size to 5MB if image is provided
    .test("fileType", "Unsupported File Format", value => !value || ['image/jpeg', 'image/png'].includes(value.type)) // Allow only specific file types if image is provided
});
export const updateEventSchema = Yup.object().shape({
  name: Yup.string().required("Name is required"),
  date: Yup.date()
    .required("Event date is required"),
  address: Yup.string().required("Address is required"),
  image: Yup.mixed()
    .notRequired() // Ensure the image field is optional
    .test("fileSize", "Image size should not exceed 10 MB", value => !value || (value.size <= 1024 * 1024 * 10)) // Limit file size to 5MB if image is provided
    .test("fileType", "Unsupported File Format", value => !value || ['image/jpeg', 'image/png'].includes(value.type)) // Allow only specific file types if image is provided
});

const timeSchema = Yup.object().shape({
  active: Yup.boolean(),
  start: Yup.string().when("active", {
    is: true,
    then: (schema) => schema.required("Start time is required"),
    otherwise: (schema) => schema.nullable(),
  }),
  end: Yup.string().when("active", {
    is: true,
    then: (schema) => schema.required("End time is required"),
    otherwise: (schema) => schema.nullable(),
  }),
});

export const branchValidation = Yup.object().shape({
  name: Yup.string().required("Branch Name is required"),
  manager_name: Yup.string().required("Manager Name is required"),
  phone: Yup.string()
    .matches(/^[0-9]+$/, "Must be only digits")
    .min(10, "Must be greater  then 10 digits")
    .max(15, "Must be less then 16 digits")
    .required("Contact Number is required"),
  email: Yup.string()
    .email("Invalid email address")
    .required("Email is required"),
  lat: Yup.number().required("Latitude is required"),
  lng: Yup.number().required("Longitude is required"),
  // address: Yup.string().required("Address is required"),
  timings: Yup.object()
    .shape({
      monday: timeSchema,
      tuesday: timeSchema,
      wednesday: timeSchema,
      thursday: timeSchema,
      friday: timeSchema,
      saturday: timeSchema,
      sunday: timeSchema,
    })
    .test("atLeastOneDay", "At least one day must be selected", (value) => {
      return Object.values(value).some((day) => day.active);
    }),
});

export const branchEditValidation = Yup.object().shape({
  name: Yup.string().required("Branch Name is required"),
  manager_name: Yup.string().required("Manager Name is required"),
  phone: Yup.string()
    .matches(/^[0-9]+$/, "Must be only digits")
    .min(10, "Must be greater  then 10 digits")
    .max(15, "Must be less then 16 digits")
    .required("Contact Number is required"),
  email: Yup.string()
    .email("Invalid email address")
    .required("Email is required"),
  timings: Yup.object()
    .shape({
      monday: timeSchema,
      tuesday: timeSchema,
      wednesday: timeSchema,
      thursday: timeSchema,
      friday: timeSchema,
      saturday: timeSchema,
      sunday: timeSchema,
    })
    .test("atLeastOneDay", "At least one day must be selected", (value) => {
      return Object.values(value).some((day) => day.active);
    }),
});

export const loyaltyValidation = Yup.object().shape({
  reward: Yup.string().required("Reward is required"),
  limit: Yup.number()
    .required("Limit is required")
    .positive("Limit must be a positive number"),
  number_of_orders: Yup.number()
    .required("No of Orders are required")
    .positive("No of Orders must be a positive number"),
  discount: Yup.number()
    .required("Discount is required")
    .positive("Discount must be a positive number"),
  validity: Yup.number()
    .required("Validity is required")
    .positive("Validity must be a positive number"),
});

export const forgotEmail = Yup.object().shape({
  email: Yup.string()
    .email("Invalid email address")
    .required("Email is required"),
});

export const forgotCode = Yup.object().shape({
  code: Yup.string()
    .required("Verification code is required")
    .matches(/^\d{4}$/, "Verification code must be 4 digits"),
});

export const forgotPassword = Yup.object().shape({
  password: Yup.string()
    .min(8, 'Password must be at least 8 characters')
    .max(15, "Must be less then 16 characters")
    .required("Password is required"),
  password_confirmation: Yup.string()
    .required("Confirm Password is required")
    .oneOf([Yup.ref("password"), null], "Confirm Password must match Password.")
    .label("Confirm Password"),
});

export const changePassword = Yup.object().shape({
  current_password: Yup.string().required("Current Password is required"),
  password: Yup.string()
    .min(8, "New Password must be at least 8 characters")
    .required("New Password is required"),
  password_confirmation: Yup.string()
    .required("Confirm Password is required")
    .oneOf([Yup.ref("password"), null], "Confirm Password must match Password.")
    .min(8, "Confirm Password must be at least 8 characters") // optional, if you want to enforce min length here too
    .label("Confirm Password"),
});

export const loginValidationSchema = Yup.object().shape({
  email: Yup.string()
    .email("Invalid email address")
    .required("Email is required"),
  password: Yup.string()
    .min(8, 'Password must be at least 8 characters')
    .max(15, "Must be less then 16 digits")
    .required("Password is required"),
});

export const addDeliviryChargeValidationSchema = Yup.object().shape({
  delivery_charges: Yup.string()
    .required("Delivery charges are required"),
});

export const contactValidationSchema = Yup.object().shape({
  first_name: Yup.string().required("First Name is required"),
  last_name: Yup.string().required("Last Name is required"),
  subject: Yup.string().required("Subject is required"),
  message: Yup.string().required("Message is required"),
  email: Yup.string()
    .email("Invalid email address")
    .required("Email is required"),
});

export const registerValidationSchema = Yup.object().shape({
  first_name: Yup.string().required("First Name is required"),
  last_name: Yup.string().required("Last Name is required"),
  gender: Yup.string().required("Gender is required"),
  email: Yup.string()
    .email("Invalid email address")
    .required("Email is required"),
  age: Yup.number()
    .required("Age is required")
    .min(18, "Must be at least 18 years old")
    .typeError("Age must be a number"),
  date_of_birth: Yup.date()
    .required("Dob is required")
    .max(new Date(), "Dob must be in the past"),
  about: Yup.string().required("Bio is required"),
  phone: Yup.string()
    .min(10, "Must be greater  then 10 digits")
    .max(15, "Must be less then 16 digits")
    .required("Contact Number is required"),
  password: Yup.string()
    .min(8, 'Password must be at least 8 characters')
    .max(15, "Must be less then 16 characters")
    .required("Password is required"),
  password_confirmation: Yup.string()
    .required("Confirm Password is required")
    .oneOf([Yup.ref("password"), null], "Confirm Password must match Password.")
    .label("Confirm Password"),
});

export const registerValidation = Yup.object().shape({
  name: Yup.string().required("Restaurant Name is required"),
  manager_name: Yup.string().required("Manager Name is required"),
  email: Yup.string()
    .email("Invalid email address")
    .required("Email is required"),
  phone: Yup.string()
    .matches(/^[0-9]+$/, "Must be only digits")
    .min(10, "Must be greater  then 10 digits")
    .max(15, "Must be less then 16 digits")
    .required("Contact Number is required"),
  password: Yup.string().required("Password is required"),
  password_confirmation: Yup.string()
    .required("Confirm Password is required")
    .oneOf([Yup.ref("password"), null], "Confirm Password must match Password.")
    .label("Confirm Password"),
});

export const promoCodeValidation = Yup.object().shape({
  code_name: Yup.string().required("Code Name is required"),
  code: Yup.string()
    .matches(/^[a-zA-Z0-9]+$/, "Code must be alphanumeric")
    .required("Code is required"),
  discount: Yup.number().required("Discount is required"),
  min_amount: Yup.number().required("Min Amount is required"),
  start_date: Yup.date().required("Start Date is required"),
  end_date: Yup.date()
    .min(Yup.ref("start_date"), "End Date must be after Start Date")
    .required("End Date is required"),
  branches: Yup.array().min(1, "Please select at least one branch"),
});

export const productValidation = Yup.object().shape({
  name: Yup.string().required("Name is required"),
  status: Yup.string().required("Status is required"),
  description: Yup.string().required("Description is required"),
  price: Yup.number()
    .required("Price is required")
    .min(0, "Price must be a positive number")
    .typeError("Price must be a valid number"),
  quantity: Yup.number()
    .required("Quantity is required")
    .min(0, "Quantity must be a positive number"),
  discounted_price: Yup.number()
    .required("Discounted price is required")
    .min(0, "Discounted price must be a positive number"),
  size: Yup.array().min(1, "Please select at least one size").required("Size is required"),

  // image: Yup.mixed()
  //   .required("Image is required")
  //   .test("fileSize", "Image size should not exceed 10 MB", value => {
  //     return value && value.size <= 1024 * 1024;
  //   })
  //   .test("fileFormat", "Unsupported Format", value => {
  //     return value && ["image/jpg", "image/jpeg", "image/png"].includes(value.type);
  //   }),
  // images: Yup.mixed()
  //   .test("fileSize", "Image size should not exceed 10 MB", (value) => {
  //     if (typeof value === "string") return true; // If it's a URL, skip this test
  //     return value && value.size <= 1024 * 1024;
  //   })
  //   .test("fileFormat", "Unsupported Format", (value) => {
  //     if (typeof value === "string") return true; // If it's a URL, skip this test
  //     return (
  //       value && ["image/jpg", "image/jpeg", "image/png"].includes(value.type)
  //     );
  //   }),
  images: Yup.array()
    .of(
      Yup.mixed()
        .test("fileSize", "Image size should not exceed 10 MB", (value) => {
          if (typeof value === "string") return true; // If it's a URL, skip this test
          return value && value.size <= 1024 * 1024 * 10; // 10 MB = 1024 * 1024
        })
        .test("fileFormat", "Unsupported format", (value) => {
          if (typeof value === "string") return true; // If it's a URL, skip this test
          return (
            value &&
            ["image/jpg", "image/jpeg", "image/png"].includes(value.type)
          );
        })
    )
    .min(1, "At least one image is required") // Require at least 1 image
    .max(5, "You can upload up to 5 images"), // Limit the number of images
  category_id: Yup.string().required("Category is required"), // Add this line
});

export const updateProductValidation = Yup.object().shape({
  name: Yup.string().required("Name is required"),
  status: Yup.string().required("Status is required"),
  description: Yup.string().required("Description is required"),
  price: Yup.number()
    .required("Price is required")
    .min(0, "Price must be a positive number")
    .typeError("Price must be a valid number"),
  sku: Yup.string().required("Stock keeping unit is required"),
  quantity: Yup.number()
    .required("Quantity is required")
    .min(0, "Quantity must be a positive number"),
  discounted_price: Yup.number()
    .required("Discounted price is required")
    .min(0, "Discounted price must be a positive number"),
  size: Yup.array().min(1, "Please select at least one size").required("Size is required"),

  images: Yup.array()
    .of(
      Yup.mixed()
        .test("fileSize", "Image size should not exceed 10 MB", (value) => {
          if (!value) return true; // If no image is provided, skip validation
          return typeof value === "string" || (value.size <= 1024 * 1024 * 10);
        })
        .test("fileFormat", "Unsupported Format", (value) => {
          if (!value) return true; // If no image is provided, skip validation
          return typeof value === "string" || ["image/jpg", "image/jpeg", "image/png"].includes(value.type);
        })
    )
    .max(5, "You can upload up to 5 images") // Allow a maximum of 5 images
    .nullable(), // Allow images to be null or undefined

  category_id: Yup.string().required("Category is required"),
});

export const paymentValidationSchema = Yup.object().shape({
  name: Yup.string()
    .required()
    .matches(/^[aA-zZ\s]+$/, "Only alphabets are allowed for Card Holder Name")
    .label("Card Holder Name"),
  cvc: Yup.string()
    .required("CVV Number is required")
    .max(3, "CVV Number must be exactly 3 digits")
    .min(3, "CVV Number must be exactly 3 digits")
    .label("CVV Number"),
  month: Yup.string()
    .test(
      "is-valid-expiration",
      "Expiration date must be greater than current date",
      function (value) {
        if (!value) return false; // if empty, return false
        const currentYear = new Date().getFullYear();
        const currentMonth = new Date().getMonth() + 1; // months are zero-based
        const [inputYear, inputMonth] = value.split("-").map(Number);
        return (
          inputYear > currentYear ||
          (inputYear === currentYear && inputMonth > currentMonth)
        );
      }
    )
    .required()
    .label("Expiration Date"),
  number: Yup.string()
    .required()
    .matches(/^\d{4}-\d{4}-\d{4}-\d{4}$/, "Invalid card number format")
    .label("Card Number"),
});

export const bankValidationSchema = Yup.object().shape({
  account_holder_name: Yup.string()
    .required("Account Holder Name is required")
    .matches(
      /^[aA-zZ\s]+$/,
      "Only alphabets are allowed for Account Holder Name"
    ),
  account_type: Yup.string()
    .required("Account Type is required")
    .matches(/^[aA-zZ\s]+$/, "Only alphabets are allowed for Account Type"),
  bank_name: Yup.string()
    .required("Bank Name is required")
    .matches(/^[aA-zZ\s]+$/, "Only alphabets are allowed for Bank Name"),
  routing_number: Yup.number().required("Routing Number is required"),
  account_number: Yup.number().required("Account Number is required"),
  confirm_account_number: Yup.number()
    .required("Confirm Account Number is required")
    .oneOf(
      [Yup.ref("account_number"), null],
      "Confirm Account Number must match Account Number."
    )
    .label("Confirm Account Number"),
});

export const profileValidationSchema = Yup.object().shape({
  first_name: Yup.string().required("First Name is required"),
  last_name: Yup.string().required("Last Name is required"),
});

export const adminProfileValidation = Yup.object().shape({
  first_name: Yup.string().required("First Name is required"),
  last_name: Yup.string().required("Last Name is required"),
  // phone: Yup.string()
  //   .matches(/^[0-9]+$/, "Must be only digits")
  //   .min(10, "Must be greater  then 10 digits")
  //   .max(15, "Must be less then 16 digits")
  //   .required("Contact Number is required"),
});

export const restaurantProfileValidation = Yup.object().shape({
  name: Yup.string().required("Name is required"),
  manager_name: Yup.string().required("Manager Name is required"),
  description: Yup.string().required("Description is required"),
  phone: Yup.string()
    .matches(/^[0-9]+$/, "Must be only digits")
    .min(10, "Must be greater  then 10 digits")
    .max(15, "Must be less then 16 digits")
    .required("Contact Number is required"),
  account_holder_name: Yup.string().required("Account Holder Name is required"),
  account_number: Yup.string()
    .matches(/^\d+$/, "Account Number must be only digits")
    .required("Account Number is required"),
});

export const branchProfileValidation = Yup.object().shape({
  name: Yup.string().required("Name is required"),
  phone: Yup.string()
    .matches(/^[0-9]+$/, "Must be only digits")
    .min(10, "Must be greater  then 10 digits")
    .max(15, "Must be less then 16 digits")
    .required("Contact Number is required"),
});

export const payoutValidation = (prevRate) =>
  Yup.object().shape({
    day: Yup.number()
      .typeError("Day must be a number")
      .required("Day is Required")
      .min(0, "Day must be a positive number")
      .test(
        "is-different",
        "The days have already been taken.",
        function (value) {
          return value !== prevRate;
        }
      ),
  });

export const commissionValidation = (prevRate) =>
  Yup.object().shape({
    rate: Yup.number()
      .typeError("Rate must be a number")
      .required("Rate is Required")
      .min(0, "Rate must be a positive number")
      .test(
        "is-different",
        "The Rate have already been taken.",
        function (value) {
          return value !== prevRate;
        }
      ),
  });

export const loyaltyDataValidation = (preValidity, preLimit) =>
  Yup.object().shape({
    limit: Yup.number()
      .typeError("limit must be a number")
      .required("limit is Required")
      .min(0, "limit must be a positive number")
      .test(
        "is-different",
        "The limit have already been taken.",
        function (value) {
          return value !== preLimit;
        }
      ),
    validity: Yup.number()
      .typeError("validity must be a number")
      .required("validity is Required")
      .min(0, "validity must be a positive number")
      .test(
        "is-different",
        "The validity have already been taken.",
        function (value) {
          return value !== preValidity;
        }
      ),
  });
