import React, { useState } from "react";
import CustomModal from "../Components/CustomModal";
import { useNavigate } from "react-router-dom";

const MODAL_STEPS = {
  INITIAL: 0,
  REASON_INPUT: 1,
  SUCCESS: 2,
};

const withModal = (WrappedComponent) => {
  return (props) => {
    const [modalState, setModalState] = useState({
      currentStep: MODAL_STEPS.INITIAL,
      show: false,
      success: false,
      heading: "",
      action: null,
      showReason: false,
      reasonValue: "",
      errorMessage: "",
    });

    const navigate = useNavigate();

    const reasonModal = (heading, action, success = false, showReason = false, navigateTo = null) => {


      setModalState({
        currentStep: MODAL_STEPS.INITIAL,
        show: true,
        success,
        heading,
        onSubmit: action,

        // action,
        showReason,
        reasonValue: "",
        errorMessage: "",

        // navigateTo
      });
    };

    const showModal = (heading, action, success = false, navigateTo = null) => {
      setModalState({
        heading,
        action,
        success,
        show: true,
        navigateTo
      });
    };

    const handleModalClose = () => {
      setModalState((prev) => ({ ...prev, show: false, action: null }));
      if (modalState.navigateTo) {
        navigate(modalState.navigateTo);
      }
    };

    const handleReasonChange = (e) => {
      setModalState((prev) => ({
        ...prev,
        reasonValue: e.target.value,
        errorMessage: "",
      }));
    };

    const handleSubmit = () => {
      if (modalState.currentStep === MODAL_STEPS.INITIAL) {
        setModalState((prev) => ({
          ...prev,
          currentStep: MODAL_STEPS.REASON_INPUT,
        }));
      } else if (modalState.currentStep === MODAL_STEPS.REASON_INPUT) {
        if (modalState.reasonValue.trim() === "") {
          setModalState((prev) => ({
            ...prev,
            errorMessage: "Reason is required.",
          }));
          return;
        }
        if (modalState.action) {
          modalState.action(modalState.reasonValue);
        }
        setModalState((prev) => ({
          ...prev,
          currentStep: MODAL_STEPS.SUCCESS,
        }));
      }
    };

    return (
      <>
        <WrappedComponent {...props} showModal={showModal} reasonModal={reasonModal} />
        <CustomModal
          show={modalState.show}
          close={handleModalClose}
          action={modalState.showReason ? handleSubmit : modalState.action}
          heading={modalState.heading}
          success={modalState.success}
          showReason={modalState.currentStep === MODAL_STEPS.REASON_INPUT}
          onChange={handleReasonChange}
          value={modalState.reasonValue}
          reasonLabel={"Please provide a reason"}
          reasonPlaceholder={"Enter reason here..."}
          btnText={"Submit"}
          errorMessage={modalState.errorMessage}
        />
      </>
    );
  };
};

export default withModal;
