import React from 'react';
import { Formik, Form } from 'formik';
import { DashboardLayout } from '../../../Components/AdminLayout/DashboardLayout';
import BackButton from '../../../Components/BackButton';
import CustomButton from '../../../Components/CustomButton';
import ImageUpload from '../../../Components/ImageUpload';
import withModal from '../../../HOC/withModal';
import { useFormStatus } from '../../../Hooks/useFormStatus';
import { addBannerSchema } from '../../../Config/Validations';
import { post } from '../../../Services/Api';
import FormikField from '../../../Components/FormikField';
import ImageSingleUpload from '../../../Components/ImageUpload/ImageSingleUpload';

const AddBanner = ({ showModal }) => {
  const { startSubmitting, stopSubmitting } = useFormStatus();
  const create = async (values, { resetForm }) => {
    startSubmitting();
    const response = await post("/admin/banner/banner", values);
    if (response.status) {
      showModal("Banner Added Successfully", null, true, '/admin/banner-management');
      resetForm();
    }
    stopSubmitting();
  };

  return (
    <DashboardLayout pageTitle="Add New Banner">
      <div className="dashCard mb-4">
        <h2 className="mainTitle text-uppercase">
          <BackButton />
          Add New Banner
        </h2>
        <div className="statsCard mt-4">
          <Formik
            initialValues={{ title: "", expiry_date: "", image: null }}
            validationSchema={addBannerSchema}
            onSubmit={create}
          >
            {({ isSubmitting, setFieldValue, errors }) => (
              <Form>
                <div className="details-wrapper">
                  <div className="row">
                    <FormikField
                      span
                      name="title"
                      label="Title"
                      labelClass="mainLabel"
                      placeholder="Enter Title"
                      className="mainInput"
                    />
                  </div>
                </div>
                <ImageSingleUpload
                  setFieldValue={setFieldValue}
                  error={errors.image}
                  initialImage="" // Provide initialImage if you have a default image URL
                />
                <div className="details-wrapper">
                  <FormikField
                    span
                    name="expiry_date"
                    label="Expiry Date"
                    type="date"
                    labelClass="mainLabel"
                    placeholder="Select Date"
                    className="mainInput"
                  />
                </div>
                <div className="row mt-4">
                  <div className="col-md-12">
                    <CustomButton
                      variant="btnBlueBG"
                      className="px-5"
                      text="Add"
                      pendingText="Submitting..."
                      isPending={isSubmitting}
                      type="submit"
                    />
                  </div>
                </div>
              </Form>
            )}
          </Formik>
        </div>
      </div>
    </DashboardLayout>
  );
};

export default withModal(AddBanner);
