import { useState, useEffect } from "react";
import { useNavigate, useParams } from "react-router-dom";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import { bannerManagementData } from "../../../Config/data";
import CustomButton from "../../../Components/CustomButton";
import { ImageSliderMultiple } from "../../../Components/ImageSliderMultiple";
import withModal from "../../../HOC/withModal";
import { dateFormat } from "../../../Utils/helper";
import { getDetails, post } from "../../../Services/Api";

const BannerDetails = ({ showModal }) => {
  const { id } = useParams();
  const [bannerData, setBannerData] = useState({});

  useEffect(() => {
    const getBanner = async () => {
      const response = await getDetails(`/admin/banner/${id}`);
      if (response.status) {
        setBannerData(response.data);
      }
    };
    getBanner();
  }, [id]);
  const navigate = useNavigate();
  const confirmPopup = () => {
    showModal(
      `Are you sure you want to Delete this Banner?`,
      () => onConfirm(),
      null,
    );
  };

  const onConfirm = async () => {
    const response = await post(`/admin/banner/${id}/delete`);
    if (response.status) {
      showModal(
        `Banner has been deleted Successfully`, //heading
        null,
        true,
        '/admin/banner-management'
      );
    }
  };

  const {
    title,
    image,
    created_at,
    expiry_date,
  } = bannerData;
  return (
    <DashboardLayout pageTitle="Banner Details">
      <div className="dashCard mb-4">
        <h2 className="mainTitle text-uppercase">
          <BackButton />
          Banner Details
        </h2>
        <div className="statsCard mt-4">
          {[
            { label: "Title", value: title },
            { label: "Image", value: image?.path },
            { label: "Published On", value: dateFormat(created_at) },
            { label: "Expiry Date", value: dateFormat(expiry_date) },
          ].map(({ label, value }) => (
            <div className="row mb-3" key={label}>
              <div className="col-12">
                <h4 className="secondaryLabel">{label}</h4>
              </div>
              <div className="col-12">
                {label == "Image" ? (
                  <img src={value} alt="" className="img-fluid banner-details-img w-100" />
                ) : (
                  <p className="secondaryText text-secondary">{value}</p>
                )}
              </div>
            </div>
          ))}
          <div className="mt-4">
            <div className="d-flex align-items-center gap-3 flex-wrap">
              <CustomButton text="Edit" onClick={() => navigate(`/admin/banner-management/edit/${id}`)} />
              <CustomButton text="Delete Banner" onClick={confirmPopup} />
            </div>
          </div>
        </div>
      </div>
    </DashboardLayout>
  );
};

export default withModal(BannerDetails);
