import { Formik, Form } from "formik";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import CustomButton from "../../../Components/CustomButton";
import withModal from "../../../HOC/withModal";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import FormikField from "../../../Components/FormikField";
import { useParams } from "react-router-dom";
import { useEffect, useState } from "react";
import { getDetails, post } from "../../../Services/Api";
import { updateBannerSchema } from "../../../Config/Validations";
import ImageSingleUpload from "../../../Components/ImageUpload/ImageSingleUpload";

const EditBanner = ({ showModal }) => {
  const { startSubmitting, stopSubmitting } = useFormStatus();
  const create = async (values, { resetForm }) => {
    startSubmitting();
    const response = await post(`/admin/banner/${id}/update`, values);
    if (response.status) {
      showModal("Banner Updated Successfully", null,
        true,
        '/admin/banner-management');
      resetForm();
    }
    stopSubmitting();
  };
  const { id } = useParams();
  const [bannerData, setBannerData] = useState({});

  useEffect(() => {
    const getBanner = async () => {
      const response = await getDetails(`/admin/banner/${id}`);
      if (response.status) {
        setBannerData(response.data);
      }
    };
    getBanner();
  }, [id]);
  return (
    <DashboardLayout pageTitle="Edit Banner">
      <div className="dashCard mb-4">
        <h2 className="mainTitle text-uppercase">
          <BackButton />
          Edit Banner
        </h2>
        <div className="statsCard mt-4">
          {Object.keys(bannerData).length > 0 && (
            <Formik
              initialValues={{ title: bannerData?.title, expiry_date: bannerData?.expiry_date, image: null }}
              validationSchema={updateBannerSchema}
              onSubmit={create}
            >
              {({ isSubmitting, errors, setFieldValue }) => (
                <Form>
                  <div className="details-wrapper">
                    <div className="row">
                      <FormikField
                        span
                        name="title"
                        label="Title"
                        labelClass="mainLabel"
                        placeholder="Enter Title"
                        className="mainInput"
                      />
                    </div>
                  </div>
                  <div>
                    <ImageSingleUpload
                      setFieldValue={setFieldValue}
                      error={errors.image}
                      initialImage={bannerData.image?.path || ""}
                      name="image"
                    />
                    {/* <ImageUpload /> */}
                  </div>
                  <div className="details-wrapper">
                    <FormikField
                      span
                      name="expiry_date"
                      label="Expiry Date"
                      type="date"
                      labelclass="mainLabel"
                      placeholder="Select Date"
                      className="mainInput"
                    />
                    {/* <FieldInput
                      span
                      name="expiry_date"
                      label="Expiry Date"
                      type="date"
                      labelclass="mainLabel"
                      placeholder="Select Date"
                      className="mainInput"
                    /> */}
                  </div>
                  <div className="row mt-4">
                    <div className="col-md-12">
                      <CustomButton
                        variant="btnBlueBG"
                        className="px-5"
                        text="Update"
                        pendingText="Submitting..."
                        isPending={isSubmitting}
                        type="submit"
                      />
                    </div>
                  </div>
                </Form>
              )}
            </Formik>
          )}
        </div>
      </div>
    </DashboardLayout>
  );
};

export default withModal(EditBanner);
