import { useState, useEffect } from "react";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import CustomTable from "../../../Components/CustomTable";
import { dateFormat, getStatus, serialNum } from "../../../Utils/helper";
import { bannerHeaders } from "../../../Config/TableHeaders"; // Table Headers
import { generalStatus } from "../../../Config/TableStatus"; // Filter Status
import { getAll, post } from "../../../Services/Api"; //Api Service
import TableDropdown from "../../../Components/TableDropdown";
import "./style.css";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import withFilters from "../../../HOC/withFilters ";
import { bannerManagementData } from "../../../Config/data";
import CustomButton from "../../../Components/CustomButton";
import { useNavigate } from "react-router-dom";

const BannerManagement = ({
  filters,
  setFilters,
  pagination,
  updatePagination,
}) => {
  const [bannerData, setBannerData] = useState([]);
  const { isSubmitting, startSubmitting, stopSubmitting } = useFormStatus();

  const fetchBanners = async () => {
    startSubmitting(true);
    const url = `/admin/banner/banners`;
    const response = await getAll(url, filters);
    if (response.status) {
      const { total, per_page, current_page, to } = response.meta;
      setBannerData(response.data);
      updatePagination({
        showData: to,
        currentPage: current_page,
        totalRecords: total,
        totalPages: Math.ceil(total / per_page),
      });
      stopSubmitting(false);
    }
    stopSubmitting(false);
  };

  useEffect(() => {
    fetchBanners();
  }, [filters]);
  const navigate = useNavigate();
  return (
    <DashboardLayout pageTitle="Banner Management">
      <div className="container-fluid">
        <div className="row">
          <div className="col-12">
            <div className="dashCard">
              <div className="row mb-5">
                <div className="col-12 d-flex align-items-center gap-3 flex-wrap justify-content-between">
                  <h2 className="mainTitle mb-0">Banner Management</h2>
                  <CustomButton onClick={() => navigate('/admin/banner-management/add')} text="Add Banner" />
                </div>
              </div>
              <div className="statsCard">
                <div className="row mb-3">
                  <div className="col-12">
                    <CustomTable
                      filters={filters}
                      setFilters={setFilters}
                      loading={isSubmitting}
                      headers={bannerHeaders}
                      pagination={pagination}
                      // if you want multiple date filters
                      dateFilters={[
                        {
                          title: 'Posted Date',
                          from: "fromDate",
                          to: "toDate",
                        },
                        {
                          title: 'Expiry Date',
                          from: "expiryFromDate",
                          to: "expiryToDate",
                        },
                      ]}
                    >
                      <tbody>
                        {bannerData?.map((item, index) => (
                          <tr key={item?.id}>
                            <td>
                              {serialNum(
                                (filters.page - 1) * filters.per_page + index + 1
                              )}
                            </td>
                            <td>{item?.title}</td>
                            <td>{dateFormat(item?.created_at)}</td>
                            <td>{dateFormat(item?.expiry_date)}</td>
                            <td>
                              <TableDropdown
                                view
                                itemId={item?.id}
                                linkPath="/admin/banner-management/details"
                                statusDetail={item?.status_detail}
                              />
                            </td>
                          </tr>
                        ))}
                      </tbody>
                    </CustomTable>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </DashboardLayout>
  );
};

export default withFilters(BannerManagement);
// Bind with HOC
// withModal is for Pop Up
// withFilters is for Pagination and default filters
// withPagination, if you want only pagination not filters
// additionalFilters, if you want extra filters on specific pages
