import { Formik, Form } from "formik";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import CustomButton from "../../../Components/CustomButton";
import { ImageSliderMultiple } from "../../../Components/ImageSliderMultiple";
import SiteInput from "../../../Components/Input/input";
import withModal from "../../../HOC/withModal";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import { dateFormat } from "../../../Utils/helper";
import FormikField from "../../../Components/FormikField";
import FieldInput from "../../../Components/Input/field";
import ImageUpload from "../../../Components/ImageUpload";
import { useNavigate } from "react-router-dom";
import { FormSelect } from "../../../Components/Select/FormSelect";
import { generalStatus } from "../../../Config/TableStatus";
import { post } from "../../../Services/Api";
import { addCategorySchema } from "../../../Config/Validations";
import ImageSingleUpload from "../../../Components/ImageUpload/ImageSingleUpload";


const AddCategory = ({ showModal }) => {
  const { startSubmitting, stopSubmitting } = useFormStatus();
  const create = async (values, { resetForm }) => {
    startSubmitting();
    const response = await post("/admin/category/category", values);
    if (response.status) {
      showModal(
        "Category Added Successfully",
        null,
        true,
        '/admin/category-management'
      );
      resetForm();
    }
    stopSubmitting();
  };

  return (
    <DashboardLayout pageTitle="Add New Category">
      <div className="dashCard mb-4">
        <h2 className="mainTitle text-uppercase">
          <BackButton />
          Add New Category
        </h2>
        <div className="statsCard mt-4">
          <Formik
            initialValues={{ name: "", status: "", image: null }}
            validationSchema={addCategorySchema}
            onSubmit={create}
          >
            {({ isSubmitting, setFieldValue, errors }) => (
              <Form>
                <div className="details-wrapper">
                  <div className="row">
                    <FormikField
                      span
                      name="name"
                      label="Category Name"
                      labelClass="mainLabel"
                      placeholder="Enter Category Name"
                      className="mainInput"
                    />
                  </div>
                </div>
                <div className="details-wrapper">
                  <FormSelect
                    name="status"
                    label="Status"
                    options={generalStatus}
                    labelclass="mainLabel"
                    className="mainInput"
                    span
                  />
                </div>
                <div className="mt-3">
                  <ImageSingleUpload
                    setFieldValue={setFieldValue}
                    error={errors.image}
                    initialImage="" // Provide initialImage if you have a default image URL
                  />
                </div>
                <div className="row mt-4">
                  <div className="col-md-12">
                    <CustomButton
                      variant="btnBlueBG"
                      className="px-5"
                      text="Add"
                      pendingText="Submitting..."
                      isPending={isSubmitting}
                      type="submit"
                    />
                  </div>
                </div>
              </Form>
            )}
          </Formik>
        </div>
      </div>
    </DashboardLayout>
  );
};

export default withModal(AddCategory);
