import { useState, useEffect } from "react";
import { useNavigate, useParams } from "react-router-dom";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import { categoryManagementData, productsManagementData } from "../../../Config/data";
import CustomButton from "../../../Components/CustomButton";
import { ImageSliderMultiple } from "../../../Components/ImageSliderMultiple";
import withModal from "../../../HOC/withModal";
import CustomTable from "../../../Components/CustomTable";
import { dateFormat, getStatus, getStatusByText, serialNum } from "../../../Utils/helper";
import { productHeaders } from "../../../Config/TableHeaders";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import { ProductStatus } from "../../../Config/TableStatus";
import withFilters from "../../../HOC/withFilters ";
import TableDropdown from "../../../Components/TableDropdown";
import { getAll, getDetails, post } from "../../../Services/Api";

const CategoryDetails = ({ showModal, filters,
  setFilters,
  pagination,
  updatePagination, }) => {
  const { id } = useParams();
  const [productData, setProductData] = useState([]);
  const { isSubmitting, startSubmitting, stopSubmitting } = useFormStatus();

  const fetchProducts = async () => {
    startSubmitting(true);
    const url = `/admin/category/${id}/products`;
    const response = await getAll(url, filters);
    if (response.status) {
      const { total, per_page, current_page, to } = response.meta;
      setProductData(response.data);
      updatePagination({
        showData: to,
        currentPage: current_page,
        totalRecords: total,
        totalPages: Math.ceil(total / per_page),
      });
      stopSubmitting();
    }
    stopSubmitting();

  };

  useEffect(() => {
    fetchProducts();
  }, [filters]);
  const [data, setData] = useState({});

  useEffect(() => {
    const getCategory = async () => {
      const response = await getDetails(`/admin/category/${id}`);
      if (response.status) {
        setData(response.data);
      }
    };
    getCategory();
  }, [id]);

  const {

    name,
    status,
    image,
  } = data;
  const confirmPopup = (id, status) => {
    console.log(status);

    showModal(
      `Are you sure you want to ${status == "active" ? "Inactivate" : "Activate"
      } this Category?`,
      () => onConfirm(id, status)
    );
  };
  const navigate = useNavigate();

  const onConfirm = async (id, status) => {
    const response = await post(`/admin/category/${id}/status`);
    if (response.status) {
      showModal(
        `Category ${response?.data?.status === "active" ? "activated" : "inactivated"
        } successfully`, //heading
        null, //action
        true, //sucess
        '/admin/category-management'
      );
    }
    showModal(
      `Category ${status == "active" ? "inactivated" : "activated"
      } successfully`, //heading
      null,
      true,
      '/admin/category-management'
    );
    // try {
    //   const response = await post(`/admin-api/users/${id}`);
    //   if (response.status) {
    //     await fetchProducts();
    //     showModal(
    //       `User ${
    //         status === "Active" ? "inactivated" : "activated"
    //       } successfully`, //heading
    //       null, //action
    //       true //sucess
    //     );
    //   }
    // } catch (error) {
    //   console.error("Error updating user status:", error);
    // }
  };
  return (
    <DashboardLayout pageTitle="Category Details">
      <div className="dashCard mb-4">
        <div className="d-flex align-items-center justify-content-between gap-3 flex-wrap">
          <h2 className="mainTitle mb-0 text-uppercase">
            <BackButton />
            Category Details
          </h2>
          <CustomButton text="Edit Category" onClick={() => navigate(`/admin/category-management/edit/${id}`)} />
        </div>
        <div className="statsCard mt-4">
          <div className="d-flex gap-3 flex-lg-nowrap flex-wrap-reverse justify-content-between mb-3">
            <div className="flex-grow-1">
              <div className="d-flex align-items-center gap-3">
                <div className="flex-shrink-0">
                  <img src={image?.path} alt="" className="img-fluid category-img-sm" />
                </div>
                <div className="flex-grow-1">
                  <h4 className="secondaryLabel">Category</h4>
                  <p className="secondaryText text-secondary">{name}</p>
                </div>
              </div>
            </div>
            <div className="flex-shrink-0 user-details-card text-end">
              <div className="d-flex align-items-center justify-content-end gap-2">
                <label className="semi-bold">Status</label>
                <span
                  className={`semi-bold ${status == 0 ? "redColor" : "greenColor"
                    }`}
                >
                  {status}
                </span>
              </div>
              <CustomButton onClick={() => confirmPopup(id, status)} text={status === "active" ? "Mark As In Active" : "Mark As Active"} className="mt-3" />
            </div>
          </div>
          <div className="mt-4">
            <h2 className="mainTitle mb-0 text-uppercase">All Products</h2>
            <CustomTable
              filters={filters}
              setFilters={setFilters}
              loading={isSubmitting}
              headers={productHeaders}
              pagination={pagination}
              // if you want multiple date filters
              dateFilters={[
                {
                  from: "fromDate",
                  to: "toDate",
                },
              ]}
              // if you want multiple select filters
              selectOptions={[
                {
                  title: "status",
                  options: ProductStatus,
                },
              ]}
            >
              <tbody>
                {productData?.map((item, index) => (
                  <tr key={item?.id}>
                    <td>
                      {serialNum(
                        (filters.page - 1) * filters.per_page + index + 1
                      )}
                    </td>
                    <td>{item?.name}</td>
                    <td>{dateFormat(item?.created_at)}</td>
                    <td>{item?.category?.name}</td>
                    <td
                      className={getStatusByText(item?.status).className}
                    >
                      {getStatusByText(item?.status).text}
                    </td>
                    <td>
                      <TableDropdown
                        view
                        itemId={item?.id}
                        linkPath="/admin/product-management/details"
                      />
                    </td>
                  </tr>
                ))}
              </tbody>
            </CustomTable>
          </div>
        </div>
      </div>
    </DashboardLayout>
  );
};
const additionalFilters = {
  type: "",
  expiryFromDate: "",
  expiryToDate: "",
};
export default withModal(withFilters(CategoryDetails, additionalFilters));
