import { Formik, Form } from "formik";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import CustomButton from "../../../Components/CustomButton";
import { ImageSliderMultiple } from "../../../Components/ImageSliderMultiple";
import SiteInput from "../../../Components/Input/input";
import withModal from "../../../HOC/withModal";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import { dateFormat } from "../../../Utils/helper";
import FormikField from "../../../Components/FormikField";
import FieldInput from "../../../Components/Input/field";
import ImageUpload from "../../../Components/ImageUpload";
import { useNavigate, useParams } from "react-router-dom";
import { useEffect, useState } from "react";
import { categoryManagementData } from "../../../Config/data";
import { FormSelect } from "../../../Components/Select/FormSelect";
import { generalStatus, ProductStatus } from "../../../Config/TableStatus";
import { getDetails, post } from "../../../Services/Api";
import ImageSingleUpload from "../../../Components/ImageUpload/ImageSingleUpload";
import { updateCategorySchema } from "../../../Config/Validations";

const EditCategory = ({ showModal }) => {
  const { startSubmitting, stopSubmitting } = useFormStatus();
  const { id } = useParams();
  const [data, setData] = useState({});
  const create = async (values, { resetForm }) => {
    startSubmitting();

    const response = await post(`/admin/category/${id}/update`, values);
    if (response.status) {
      showModal("Category Updated Successfully", null,
        true,
        '/admin/category-management'
      );
      resetForm();
    }
    stopSubmitting();
  };


  useEffect(() => {
    const getCategory = async () => {

      const response = await getDetails(`/admin/category/${id}`);
      if (response.status) {
        setData(response?.data);
      }
    };
    getCategory();
  }, [id]);
  console.log(data)
  return (
    <DashboardLayout pageTitle="Edit Category">
      <div className="dashCard mb-4">
        <h2 className="mainTitle text-uppercase">
          <BackButton />
          Edit Category
        </h2>
        <div className="statsCard mt-4">
          {Object.keys(data).length > 0 && (
            <Formik
              initialValues={{ name: data?.name, status: data?.status, image: null }}
              validationSchema={updateCategorySchema}
              onSubmit={create}
            >
              {({ isSubmitting, errors, setFieldValue }) => (
                <Form>
                  <div className="details-wrapper">
                    <div className="row">
                      <FormikField
                        span
                        name="name"
                        label="Category Name"
                        labelClass="mainLabel"
                        placeholder="Enter Category Name"
                        className="mainInput"
                      />
                    </div>
                  </div>
                  <div className="details-wrapper">
                    <FormSelect
                      name="status"
                      label="Status"
                      options={ProductStatus}
                      labelclass="mainLabel"
                      className="mainInput"
                      span
                    />
                  </div>
                  <div className="mt-3">
                    <ImageSingleUpload setFieldValue={setFieldValue}
                      error={errors.image}
                      initialImage={data?.image?.path || ""}
                      name="image" />
                  </div>
                  <div className="row mt-4">
                    <div className="col-md-12">
                      <CustomButton
                        variant="btnBlueBG"
                        className="px-5"
                        text="Update"
                        pendingText="Submitting..."
                        isPending={isSubmitting}
                        type="submit"
                      />
                    </div>
                  </div>
                </Form>
              )}
            </Formik>
          )}
        </div>
      </div>
    </DashboardLayout>
  );
};

export default withModal(EditCategory);
