import { useState, useEffect } from "react";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import StatCard from "../../../Components/StatsCard/index";
import "./style.css";
import {
  cardLinks,
  generateNextFiveYears,
  getIcon,
  getText,
} from "../../../Utils/helper";
import { getAll } from "../../../Services/Api";
import { Graph } from "../../../Components/Graph";
import { images } from "../../../Assets";

export const Dashboard = () => {
  const [data, setData] = useState([]);
  const [selectedValue, setSelectedValue] = useState(new Date().getFullYear());
  const [chartdata, setChartData] = useState({});
  const [userChartData, setUserChartData] = useState({});
  const [revenueChartData, setRevenueChartData] = useState({});
  const years = generateNextFiveYears();

  const fetchHomeData = async (year = "") => {
    const url = year ? `/admin/dashboard/stats?year=${year}` : "/admin/dashboard/stats";
    const response = await getAll(url);

    if (response && response.status) {
      setData([
        { id: 1, image: images.statCardImg1, text: "total users", change: response.data.total_users, increase: true },
        { id: 2, image: images.statCardImg2, text: "total orders", change: response.data.total_orders, increase: true },
        { id: 3, image: images.statCardImg3, text: "total revenue", change: `$${response.data.total_earnings}`, increase: true },
        { id: 4, image: images.statCardImg4, text: "total banners", change: response.data.total_banners, increase: true },
      ]);

      setChartData({
        heading: "Total Earning",
        label: "Sales",
        data: response.data.monthsCountEarnings,
      });

      setUserChartData({
        heading: "Total Users Registered",
        label: "Users",
        data: response.data.monthsCount,
      });
      setRevenueChartData({
        heading: "Total Revenue",
        label: "Revenue",
        data: response.data.monthsCountEarnings,
      });
    }
  };

  const handleChartChange = async (year) => {
    const url = year ? `/admin/dashboard/chartStats?year=${year}` : "/admin/dashboard/chartStats";
    const response = await getAll(url);

    if (response && response.status) {
      setChartData({
        heading: "Total Earning",
        label: "Sales",
        data: response.data.monthsCountEarnings,
      });
    }
  };

  const handleUserChange = async (year) => {
    const url = year ? `/admin/dashboard/userStats?year=${year}` : "/admin/dashboard/userStats";
    const response = await getAll(url);

    if (response && response.status) {
      setUserChartData({
        heading: "Total Users Registered",
        label: "Users",
        data: response.data.monthsCount,
      });
    }
  };

  const handleRevenueChange = async (year) => {
    const url = year ? `/admin/dashboard/chartStats?year=${year}` : "/admin/dashboard/chartStats";
    const response = await getAll(url);

    if (response && response.status) {
      setRevenueChartData({
        heading: "Total Revenue",
        label: "Revenue",
        data: response.data.monthsCountEarnings,
      });
    }
  };

  useEffect(() => {
    fetchHomeData(selectedValue);
  }, []);

  return (
    <DashboardLayout pageTitle="Dashboard">
      <div className="container-fluid">
        <div className="row mb-3">
          <h2 className="mainTitle mb-0">Dashboard</h2>
          <div className="row">
            {data.map((stats) => (
              <div className="col-xxl-3 col-md-6 col-xl-4 mb-3" key={stats.id}>
                <StatCard item={stats} statsChange />
              </div>
            ))}
          </div>
        </div>

        <div className="row mb-3">
          <div className="statsCard">
            <Graph
              item={chartdata}
              selectedValue={selectedValue}
              onSelectChange={handleChartChange}
              options={years}
            />
          </div>
        </div>
        <div className="row mb-3">
          <div className="statsCard">
            <Graph
              item={userChartData}
              selectedValue={selectedValue}
              onSelectChange={handleUserChange}
              options={years}
            />
          </div>
        </div>
        <div className="row mb-3">
          <div className="statsCard">
            <Graph
              item={revenueChartData}
              selectedValue={selectedValue}
              onSelectChange={handleRevenueChange}
              options={years}
            />
          </div>
        </div>
      </div>
    </DashboardLayout>
  );
};
