import { Form, Formik } from 'formik';
import React from 'react';
import { DashboardLayout } from '../../../Components/AdminLayout/DashboardLayout';
import BackButton from '../../../Components/BackButton';
import CustomButton from '../../../Components/CustomButton';
import FormikField from '../../../Components/FormikField';
import { addEventSchema } from '../../../Config/Validations';
import withModal from '../../../HOC/withModal';
import { useFormStatus } from '../../../Hooks/useFormStatus';
import { post } from '../../../Services/Api';
import ImageSingleUpload from '../../../Components/ImageUpload/ImageSingleUpload';

const AddEvent = ({ showModal }) => {
  const { startSubmitting, stopSubmitting } = useFormStatus();
  const create = async (values, { resetForm }) => {
    startSubmitting();
    const response = await post("/admin/event/event", values);
    if (response.status) {
      showModal("Event Added Successfully", null, true, '/admin/event-management');
      resetForm();
    }
    // showModal("Event Added Successfully", null, true, '/admin/event-management');
    stopSubmitting();
  };

  return (
    <DashboardLayout pageTitle="Add New Event">
      <div className="dashCard mb-4">
        <h2 className="mainTitle text-uppercase">
          <BackButton />
          Add New Event
        </h2>
        <div className="statsCard mt-4">
          <Formik
            initialValues={{ name: "", date: "", address: "", image: null }}
            validationSchema={addEventSchema}
            onSubmit={create}
          >
            {({ isSubmitting, setFieldValue, errors }) => (
              <Form>
                <div className="details-wrapper">
                  <div className="row">
                    <FormikField
                      span
                      name="name"
                      label="Event Name"
                      labelClass="mainLabel"
                      placeholder="Enter Event Name"
                      className="mainInput"
                    />
                  </div>
                </div>
                <ImageSingleUpload
                  setFieldValue={setFieldValue}
                  error={errors.image}
                  initialImage="" // Provide initialImage if you have a default image URL
                />
                <div className="details-wrapper">
                  <FormikField
                    span
                    name="date"
                    label="Date"
                    type="date"
                    labelClass="mainLabel"
                    placeholder="Select Date"
                    className="mainInput"
                  />
                </div>
                <div className="details-wrapper">
                  <FormikField
                    span
                    name="address"
                    label="Address"
                    type="text"
                    labelClass="mainLabel"
                    placeholder="Enter Address"
                    className="mainInput"
                  />
                </div>
                <div className="row mt-4">
                  <div className="col-md-12">
                    <CustomButton
                      variant="btnBlueBG"
                      className="px-5"
                      text="Add"
                      pendingText="Submitting..."
                      isPending={isSubmitting}
                      type="submit"
                    />
                  </div>
                </div>
              </Form>
            )}
          </Formik>
        </div>
      </div>
    </DashboardLayout>
  );
};

export default withModal(AddEvent);
