import { Form, Formik } from "formik";
import { useEffect, useState } from "react";
import { useParams } from "react-router-dom";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import CustomButton from "../../../Components/CustomButton";
import FormikField from "../../../Components/FormikField";
import { addEventSchema, updateBannerSchema, updateEventSchema } from "../../../Config/Validations";
import withModal from "../../../HOC/withModal";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import { getDetails, post } from "../../../Services/Api";
import ImageSingleUpload from "../../../Components/ImageUpload/ImageSingleUpload";

const EditEvent = ({ showModal }) => {
  const { startSubmitting, stopSubmitting } = useFormStatus();
  const create = async (values, { resetForm }) => {
    startSubmitting();
    const response = await post(`/admin/event/${id}/update`, values);
    if (response.status) {
      showModal("Event Updated Successfully", null,
        true,
        '/admin/event-management');
      resetForm();
    }
    stopSubmitting();
  };
  const { id } = useParams();
  const [eventData, setEventData] = useState({});

  useEffect(() => {
    const getEvent = async () => {
      const response = await getDetails(`/admin/event/${id}`);
      if (response.status) {
        setEventData(response.data);
      }
    };
    getEvent();
  }, [id]);
  return (
    <DashboardLayout pageTitle="Edit Event">
      <div className="dashCard mb-4">
        <h2 className="mainTitle text-uppercase">
          <BackButton />
          Edit Event
        </h2>
        <div className="statsCard mt-4">
          {Object.keys(eventData).length > 0 && (
            <Formik
              initialValues={{ name: eventData?.name || 'ABC', date: eventData?.date, address: eventData?.address || 'xxx', image: null }}
              validationSchema={updateEventSchema}
              onSubmit={create}
            >
              {({ isSubmitting, errors, setFieldValue }) => (
                <Form>
                  <div className="details-wrapper">
                    <div className="row">
                      <FormikField
                        span
                        name="name"
                        label="Event Name"
                        labelClass="mainLabel"
                        placeholder="Enter Event Name"
                        className="mainInput"
                      />
                    </div>
                  </div>
                  <div>
                    <ImageSingleUpload
                      setFieldValue={setFieldValue}
                      error={errors.image}
                      initialImage={eventData.image?.path || ""}
                      name="image"
                    />
                    {/* <ImageUpload /> */}
                  </div>
                  <div className="details-wrapper">
                    <FormikField
                      span
                      name="date"
                      label="Date"
                      type="date"
                      labelClass="mainLabel"
                      placeholder="Select Date"
                      className="mainInput"
                    />
                  </div>
                  <div className="details-wrapper">
                    <div className="row">
                      <FormikField
                        span
                        name="address"
                        label="Address"
                        labelClass="mainLabel"
                        placeholder="Enter Address"
                        className="mainInput"
                      />
                    </div>
                  </div>

                  <div className="row mt-4">
                    <div className="col-md-12">
                      <CustomButton
                        variant="btnBlueBG"
                        className="px-5"
                        text="Update"
                        pendingText="Submitting..."
                        isPending={isSubmitting}
                        type="submit"
                      />
                    </div>
                  </div>
                </Form>
              )}
            </Formik>
          )}
        </div>
      </div>
    </DashboardLayout>
  );
};

export default withModal(EditEvent);
