import { useEffect, useState } from "react";
import { useNavigate, useParams } from "react-router-dom";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import CustomButton from "../../../Components/CustomButton";
import { eventManagementData } from "../../../Config/data";
import withModal from "../../../HOC/withModal";
import { getDetails, post } from "../../../Services/Api";
import { dateFormat } from "../../../Utils/helper";

const EventDetails = ({ showModal }) => {
  const { id } = useParams();
  const [eventData, setEventData] = useState({});

  useEffect(() => {
    const getBanner = async () => {
      const response = await getDetails(`/admin/event/${id}`);
      //   const response = eventManagementData;
      if (response.status) {
        setEventData(response.data);
      }
    };
    getBanner();
  }, [id]);
  const navigate = useNavigate();
  const confirmPopup = () => {
    showModal(
      `Are you sure you want to Delete this Event?`,
      () => onConfirm(),
      null,
    );
  };

  const onConfirm = async () => {
    const response = await post(`/admin/event/${id}/delete`);
    if (response.status) {
      showModal(
        `Event has been deleted Successfully`, //heading
        null,
        true,
        '/admin/event-management'
      );
    }
  };

  const {
    name,
    image,
    address,
    date,
  } = eventData;
  return (
    <DashboardLayout pageTitle="Event Details">
      <div className="dashCard mb-4">
        <h2 className="mainTitle text-uppercase">
          <BackButton />
          Event Details
        </h2>
        <div className="statsCard mt-4">
          {[
            { label: "Event Name", value: name || 'ABC' },
            { label: "Image", value: image?.path },
            { label: "Date", value: dateFormat(date || '10-03-2025') },
            { label: "Address", value: address || 'xxx' },
          ].map(({ label, value }) => (
            <div className="row mb-3" key={label}>
              <div className="col-12">
                <h4 className="secondaryLabel">{label}</h4>
              </div>
              <div className="col-12">
                {label == "Image" ? (
                  <img src={value} alt="" className="img-fluid banner-details-img w-100" />
                ) : (
                  <p className="secondaryText text-secondary">{value}</p>
                )}
              </div>
            </div>
          ))}
          <div className="mt-4">
            <div className="d-flex align-items-center gap-3 flex-wrap">
              <CustomButton text="Edit" onClick={() => navigate(`/admin/event-management/edit/${id}`)} />
              <CustomButton text="Delete Event" onClick={confirmPopup} />
            </div>
          </div>
        </div>
      </div>
    </DashboardLayout>
  );
};

export default withModal(EventDetails);
