import React, { useState, useEffect } from "react";
import { useParams } from "react-router-dom";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import { dateFormat } from "../../../Utils/helper";
import { getDetails, post } from "../../../Services/Api";
import CustomInput from "../../../Components/CustomInput";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import CustomButton from "../../../Components/CustomButton";
import withModal from "../../../HOC/withModal";

const FeedbackDetails = ({ showModal }) => {
  const { id } = useParams();
  const [queriesItems, setQueries] = useState([]);
  const [adminComments, setAdminComments] = useState("");
  const { isSubmitting, startSubmitting, stopSubmitting } = useFormStatus();

  const loadQueries = async () => {
    let response = await getDetails("/admin-api/feedback/" + id);
    if (response.status) {
      setQueries(response.detail);
      setAdminComments(response.detail.admin_comments); // Initialize admin comments
    }
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    startSubmitting();
    let response = await post(`/admin-api/feedback/${id}`, {
      admin_comments: adminComments,
    });
    if (response.status) {
      showModal(
        'Updated Successfully',
        null,
        true
      );
      loadQueries();
    } else {
      console.log("error");
    }
    stopSubmitting();
  };

  useEffect(() => {
    loadQueries();
  }, []);

  return (
    <>
      <DashboardLayout pageTitle="Feedback Details">
        <div className="dashCard mb-4">
          <div className="row mb-3">
            <div className="col-md-6 mb-2">
              <h2 className="mainTitle">
                <BackButton />
                Feedback Details
              </h2>
            </div>
          </div>
          <div className="row">
            <div className="col-6">
              <div className="row mb-3">
                <div className="col-xl-12 col-md-12">
                  <h4 className="secondaryLabel">Name:</h4>
                </div>
                <div className="col-xl-12 col-md-12">
                  <p className="secondaryText text-secondary">
                    {queriesItems.name}
                  </p>
                </div>
              </div>

              <div className="row mb-3">
                <div className="col-xl-12 col-md-12">
                  <h4 className="secondaryLabel">Email address:</h4>
                </div>
                <div className="col-xl-12 col-md-12">
                  <p className="secondaryText text-secondary">
                    {queriesItems.email}
                  </p>
                </div>
              </div>

              <div className="row mb-3">
                <div className="col-xl-12 col-md-12">
                  <h4 className="secondaryLabel">Phone No:</h4>
                </div>
                <div className="col-xl-12 col-md-12">
                  <p className="secondaryText text-secondary">
                    {queriesItems.phone}
                  </p>
                </div>
              </div>
              <div className="row mb-3">
                <div className="col-xl-12 col-md-12">
                  <h4 className="secondaryLabel">Subject:</h4>
                </div>
                <div className="col-xl-12 col-md-12">
                  <p className="secondaryText text-secondary">
                    {queriesItems.subject}
                  </p>
                </div>
              </div>
              <div className="row mb-3">
                <div className="col-xl-12 col-md-12">
                  <h4 className="secondaryLabel">Date:</h4>
                </div>
                <div className="col-xl-12 col-md-12">
                  <p className="secondaryText text-secondary">
                    {dateFormat(queriesItems.created_at)}
                  </p>
                </div>
              </div>
              <div className="row mb-3">
                <div className="col-xl-12 col-md-12">
                  <h4 className="secondaryLabel">Message:</h4>
                </div>
                <div className="col-xl-12 col-md-12">
                  <p className="secondaryText text-secondary">
                    {queriesItems.message}
                  </p>
                </div>
              </div>

              <div className="row mb-3">
                <div className="col-xl-12 col-md-12">
                  <h4 className="secondaryLabel">Admin Comments:</h4>
                </div>
                <div className="col-xl-12 col-md-12">
                  {queriesItems.status === "Resolved" ? (
                    <p className="secondaryText text-secondary">
                      {queriesItems.admin_comments}
                    </p>
                  ) : (
                    <CustomInput
                      inputclass="mainInput"
                      type="textarea"
                      placeholder="Enter Comments"
                      rows="10"
                      id="description"
                      value={adminComments}
                      onChange={(e) => setAdminComments(e.target.value)}
                    />
                  )}
                </div>
                {queriesItems.status === "Resolved" ? (
                  ""
                ) : (
                  <div className="row">
                    <div className="col-md-4">
                      <CustomButton
                        variant="btnBlueBG"
                        className="px-5"
                        text="Save"
                        pendingText="Submitting..."
                        isPending={isSubmitting}
                        type="submit"
                        onClick={handleSubmit}
                      />
                    </div>
                  </div>
                )}
              </div>
            </div>
          </div>
        </div>
      </DashboardLayout>
    </>
  );
};

export default withModal(FeedbackDetails);
