import { useState, useEffect } from "react";
import { useNavigate, useParams } from "react-router-dom";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import { orderManagementData } from "../../../Config/data";
import CustomButton from "../../../Components/CustomButton";
import { ImageSliderMultiple } from "../../../Components/ImageSliderMultiple";
import withModal from "../../../HOC/withModal";
import { dateFormat, serialNum } from "../../../Utils/helper";
import CustomTable from "../../../Components/CustomTable";
import { cartHeaders } from "../../../Config/TableHeaders";
import './style.css'
import { getDetails, post } from "../../../Services/Api";
import CustomModal from "../../../Components/CustomModal";
import IntlTelInput from 'react-intl-tel-input';
import 'react-intl-tel-input/dist/main.css';
const OrderDetails = ({ showModal, reasonModal }) => {
  const { id } = useParams();
  const [show3, setShow3] = useState(false);
  const [show4, setShow4] = useState(false);
  const [show5, setShow5] = useState(false);
  const [currentSelectedProduct, setCurrentSelectedProduct] = useState();

  const handleClose3 = () => setShow3(false);
  const handleClose4 = () => setShow4(false);
  const handleClose5 = () => setShow5(false);

  const [data, setData] = useState({});
  const getOrder = async () => {
    const response = await getDetails(`/admin/order/${id}`);
    if (response.status) {
      setData(response.data);
    }
  };
  const reportAction = () => {
    setShow3(false);
    setShow4(true);
  }
  useEffect(() => {
    getOrder()
  }, [id]);
  const confirmPopup = async (id, status) => {
    showModal(
      `Are you sure you want to mark this Order as Delivered?`,
      () => onConfirm(id, status),
    );

  };
  const navigate = useNavigate();
  const CartTotal = () => {
    const total = data?.details?.reduce((sum, item) => {
      return sum + item.price * item.quantity;
    }, 0);
    return total
  }
  const onConfirm = async (id, status) => {
    const response = await post("/admin/order/changeStatus", { 'order_id': id, 'status': status });
    if (response.status) {
      showModal(
        `Order ${id} has been Delivered successfully`, //heading
        null,
        true,
        '/admin/order-management'
      );
    }
  };
  const reportedAction = () => {
    setShow4(false);
    setShow5(true);
  }
  const cancelPopup = (id, status) => {
    console.log("id", id);
    setCurrentSelectedProduct(id);
    setShow3(true);
  };
  // const handleReportModalSubmit = async (values) => {
  //   console.log("values", values.reason);
  //   values.reportable_type = 'App\\Models\\Order';
  //   values.reportable_id = id;
  //   // Access rating and review values here
  //   values.product_id = "5";
  //   let response = await post("/user/report/create", values);
  //   if (response.status) {
  //     setShow4(false);
  //     setShow5(true);
  //   }
  //   // You can now perform further actions, like sending data to an API
  //   // setModalVisible(false); // Close the modal after submission
  // };
  const cancelReasonPopup = async (values) => {
    console.log('cancelReasonPopup');
    // try {
    console.log("reason", values?.reason);
    const response = await post("/admin/order/changeStatus", { 'order_id': currentSelectedProduct, 'status': "cancelled", 'reason': values?.reason });
    if (response.status) {
      setShow4(false);
      setShow5(true);
      // reasonModal(
      //   `Order ${id} has been cancelled Successfully`, //heading
      //   null,
      //   true,
      //   '/admin/order-management',
      // );

      // reasonModal(
      //   `Order ${id} has been cancelled Successfully`, //heading
      //   null, //action
      //   true, //sucess
      //   false, // showReason
      //   () => {
      //     // If you want to Navigate after the modal closes
      //     navigate(`//admin/order-management`);
      //   }
      // )
    }

    // } catch (error) {
    //   console.error("Error updating user status:", error);
    // }
  };
  return (
    <DashboardLayout pageTitle="Order Details">
      <div className="dashCard mb-4">
        <div className="d-flex align-items-center justify-content-between flex-wrap gap-3">
          <h2 className="mainTitle mb-0 text-uppercase">
            <BackButton />
            Order Details
          </h2>
          {data?.status == "pending" ? (
            <CustomButton onClick={() => cancelPopup(data?.id, 'delivered')} text="Cancel Order" />
          ) : ''}
        </div>
        <div className="statsCard mt-4">
          <div className="d-flex gap-3 flex-lg-nowrap flex-wrap-reverse justify-content-between mb-3">
            <div className="flex-grow-1">
              <div className="mt-4">
                {[
                  { label: "Order ID", value: "#" + data?.id },
                  { label: "Order Date", value: dateFormat(data?.created_at) },
                ].map(({ label, value }) => (
                  <div className="row mb-3" key={label}>
                    <div className="col-12">
                      <h4 className="secondaryLabel">{label}</h4>
                    </div>
                    <div className="col-12">
                      {label == "Interest and Hobbies" ? (
                        value?.map((item, index) => (
                          <p className="secondaryText text-secondary" key={index}>{item}</p>
                        ))
                      ) : (
                        <p className="secondaryText text-secondary">{value}</p>
                      )}
                    </div>
                  </div>
                ))}
                {data?.status == "delivered" ? (
                  <>
                    <h4 className="secondaryLabel">Delivery Date</h4>
                    <p className="secondaryText text-secondary">{dateFormat(data?.updated_at)}</p>
                  </>
                ) : ""}
              </div>
            </div>
            <div className="flex-shrink-0 user-details-card text-end">
              <div className="d-flex align-items-center justify-content-end gap-2">
                <label className="semi-bold">Status</label>
                <span
                  className={`semi-bold ${data?.status === "pending" ? "primaryColor" : data?.status === "cancelled" ? "redColor" : "greenColor"
                    }`}
                >
                  {data?.status?.toUpperCase()}
                </span>
              </div>
              {data?.status == "pending" ? (
                <CustomButton onClick={() => confirmPopup(data?.id, 'delivered')} text={"Mark As Delivered"} className="mt-3" />
              ) : ''}
            </div>
          </div>
          <CustomTable
            noFilters
            headers={cartHeaders}
          >
            <tbody>
              {data?.details?.map((item, index) => (
                <tr key={item?.id}>
                  <td>{index < 10 ? `0${index + 1}` : index}</td>
                  <td>
                    <div className="d-flex align-items-center gap-2">
                      <div className="flex-shrink-0">
                        <img src={item?.product?.images[0]?.path} alt="" className="img-fluid category-img-sm" />
                      </div>
                      <div className="flex-grow-1">
                        <p className="mb-0">{item?.product?.name}</p>
                        <p className="mb-0 mt-1">{item?.product?.category?.name}</p>
                      </div>
                    </div>
                  </td>
                  <td>${item?.price}</td>
                  <td>{item?.quantity}</td>
                  <td>{item?.size?.name}</td>
                  <td>${item?.price * item?.quantity}</td>
                </tr>
              ))}
            </tbody>
          </CustomTable>
          <hr />
          <h2 className="mainTitle">Order Summary</h2>
          <hr />
          <div className="d-flex align-items-center gap-2 justify-content-between flex-wrap">
            <p className="secondaryText text-secondary">Sub-Total</p>
            <h4 className="secondaryLabel">${CartTotal()}</h4>
          </div>
          <div className="d-flex align-items-center mt-3 gap-2 justify-content-between flex-wrap">
            <p className="secondaryText text-secondary">Delivery Charges</p>
            <h4 className="secondaryLabel">${data?.delivery_charges}</h4>
          </div>
          <hr />
          <div className="d-flex align-items-center gap-2 justify-content-between flex-wrap">
            <p className="secondaryText text-secondary">Total</p>
            <h4 className="secondaryLabel">${data?.total_price}</h4>
          </div>
          {data?.address
            ?.sort((a, b) => {
              const order = ['contact', 'shipping', 'billing'];
              return order.indexOf(a.type) - order.indexOf(b.type);
            })
            .map((value, index) => (
              <div key={index}>
                <p className="mainTitle my-3 p-2 grayBg">
                  {value?.type == 'contact' ? 'Contact' : value?.type?.charAt(0).toUpperCase() + value?.type?.slice(1).toLowerCase()}
                  {value?.type == 'contact' ? ' Information' : ' Address'}
                </p>

                <div className="mt-4">
                  {value?.type === 'contact' && (
                    <div>
                      <div className="row mb-3" key="User Name">
                        <div className="col-12">
                          <h4 className="secondaryLabel">User Name</h4>
                        </div>
                        <div className="col-12">
                          <p className="secondaryText text-secondary"> {value?.first_name + ' ' + value?.last_name}</p>
                        </div>
                      </div>
                      <div className="row mb-3" key="Contact Number">
                        <div className="col-12">
                          <h4 className="secondaryLabel">Contact Number</h4>
                        </div>
                        <div className="col-12">
                          <p className="secondaryText text-secondary">

                            <IntlTelInput
                              disabled={true}
                              containerClassName="intl-tel-input  "
                              inputClassName="border-0"
                              defaultCountry={value?.country_code.toLowerCase()} // Set initial country based on country code
                              value={`${value?.dial_code}${value?.phone}`} // Combine dialing code and number
                              separateDialCode={false} // Show dialing code separately
                              preferredCountries={[value?.country_code.toLowerCase()]}

                            />
                          </p>
                        </div>
                      </div>
                      <div className="row mb-3" key="Contact Number">
                        <div className="col-12">
                          <h4 className="secondaryLabel">Email</h4>
                        </div>
                        <div className="col-12">
                          <p className="secondaryText text-secondary"> {value?.email}</p>
                        </div>
                      </div>
                    </div>
                  )}
                  {value?.type !== 'contact' && (
                    <div>
                      <div className="row mb-3" key="Contact Number">
                        <div className="col-12">
                          <h4 className="secondaryLabel">Customer Name</h4>
                        </div>
                        <div className="col-12">
                          <p className="secondaryText text-secondary">  {value?.first_name + ' ' + value?.last_name}</p>
                        </div>
                      </div>
                      <div className="row mb-3" key="Contact Number">
                        <div className="col-12">
                          <h4 className="secondaryLabel">Contact Number</h4>
                        </div>
                        <div className="col-12">
                          <p className="secondaryText text-secondary">
                            <IntlTelInput
                              disabled={true}
                              containerClassName="intl-tel-input  "
                              inputClassName="border-0"
                              defaultCountry={value?.country_code.toLowerCase()} // Set initial country based on country code
                              value={`${value?.dial_code}${value?.phone}`} // Combine dialing code and number
                              separateDialCode={false} // Show dialing code separately
                              preferredCountries={[value?.country_code.toLowerCase()]}

                            />
                          </p>
                        </div>
                      </div>
                      <div className="row mb-3" key="Contact Number">
                        <div className="col-12">
                          <h4 className="secondaryLabel">Address</h4>
                        </div>
                        <div className="col-12">
                          <p className="secondaryText text-secondary"> {value?.address}</p>
                        </div>
                      </div>
                      <div className="row mb-3" key="Contact Number">
                        <div className="col-12">
                          <h4 className="secondaryLabel">Country</h4>
                        </div>
                        <div className="col-12">
                          <p className="secondaryText text-secondary"> {value?.country}</p>
                        </div>
                      </div>
                      <div className="row mb-3" key="Contact Number">
                        <div className="col-12">
                          <h4 className="secondaryLabel">State</h4>
                        </div>
                        <div className="col-12">
                          <p className="secondaryText text-secondary"> {value?.state}</p>
                        </div>
                      </div>
                      <div className="row mb-3" key="Contact Number">
                        <div className="col-12">
                          <h4 className="secondaryLabel">City</h4>
                        </div>
                        <div className="col-12">
                          <p className="secondaryText text-secondary"> {value?.city}</p>
                        </div>
                      </div>
                      <div className="row mb-3" key="Contact Number">
                        <div className="col-12">
                          <h4 className="secondaryLabel">Zip Code</h4>
                        </div>
                        <div className="col-12">
                          <p className="secondaryText text-secondary"> {value?.zip_code}</p>
                        </div>
                      </div>
                    </div>
                  )}
                </div>
              </div>

            ))}
          {data?.status === "cancelled" ? (

            <div className="mt-4">
              <h2 className="mainTitlep-2 grayBg">Cancellation Reason</h2>
              <div className="mt-4">
                <div className="row mb-3">
                  <div className="col-12">
                    <h4 className="secondaryLabel">Cancellation Reason</h4>
                  </div>
                  <div className="col-12">
                    <p className="secondaryText text-secondary">{data?.rejection_reason}</p>
                  </div>
                </div>
              </div>
            </div>
          ) : ''}
        </div>
      </div>
      <CustomModal
        show={show3}
        action={reportAction}
        close={handleClose3}
        heading="Cancel Order"
        para="Are you sure you want to cancel this order?"
      />
      <CustomModal
        show={show4}
        close={handleClose4}
        showReason
        action={reportedAction}
        reasonLabel="Report Reason"
        onSubmit={cancelReasonPopup}
      // heading="Review has been submitted"
      />
      <CustomModal
        show={show5}
        close={handleClose5}
        heading="Successful"
        para="Order has been cancelled successfully"
        success
      // heading="Review has been submitted"
      />
    </DashboardLayout>
  );
};

export default withModal(OrderDetails);
