import { useState, useEffect } from "react";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import CustomTable from "../../../Components/CustomTable";
import { dateFormat, getStatus, serialNum } from "../../../Utils/helper";
import { paymentLogsHeaders } from "../../../Config/TableHeaders"; // Table Headers
import { generalStatus } from "../../../Config/TableStatus"; // Filter Status
import { getAll, post } from "../../../Services/Api"; //Api Service
import TableDropdown from "../../../Components/TableDropdown";
import "./style.css";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import withFilters from "../../../HOC/withFilters ";
import withModal from "../../../HOC/withModal";
import { paymentLogsManagementData } from "../../../Config/data";
import { Form, Formik } from "formik";
import FormikField from "../../../Components/FormikField";
import CustomButton from "../../../Components/CustomButton";

const PaymentLogs = ({
  showModal,
  filters,
  setFilters,
  pagination,
  updatePagination,
}) => {
  const [paymentLogsData, setPaymentLogsData] = useState([]);
  const { isSubmitting, startSubmitting, stopSubmitting } = useFormStatus();

  const fetchPaymentLogs = async () => {
    startSubmitting(true);
    const url = `/admin/paymentLog/paymentLogs`;
    const response = await getAll(url, filters);
    if (response.status) {
      const { total, per_page, current_page, to } = response.meta;
      setPaymentLogsData(response.data);
      updatePagination({
        showData: to,
        currentPage: current_page,
        totalRecords: total,
        totalPages: Math.ceil(total / per_page),
      });
      stopSubmitting(false);
    }
    stopSubmitting(false);
  };

  const getConatctAddress = (paymentLog) => {
    const contactAddress = paymentLog.paymentable.address.find(address => address.type === 'contact');
    return contactAddress;
  }

  useEffect(() => {
    fetchPaymentLogs();
  }, [filters]);
  return (
    <DashboardLayout pageTitle="Payment Logs">
      <div className="container-fluid">
        <div className="row">
          <div className="col-12">
            <div className="dashCard">
              <div className="row mb-5">
                <div className="col-md-6">
                  <h2 className="mainTitle mb-0">Payment Logs</h2>
                </div>
              </div>
              <div className="statsCard">
                <div className="row mb-3">
                  <div className="col-12">
                    <CustomTable
                      filters={filters}
                      setFilters={setFilters}
                      loading={isSubmitting}
                      headers={paymentLogsHeaders}
                      pagination={pagination}
                      // if you want multiple date filters
                      dateFilters={[
                        {
                          from: "fromDate",
                          to: "toDate",
                        },
                      ]}
                    >
                      <tbody>
                        {paymentLogsData?.map((item, index) => (
                          <tr key={item?.id}>
                            <td>
                              {serialNum(
                                (filters.page - 1) * filters.per_page + index + 1
                              )}
                            </td>
                            <td>#{item?.id}</td>
                            <td>{item?.user?.first_name ? item?.user?.first_name + " " + item?.user?.last_name : getConatctAddress(item).first_name + " " + getConatctAddress(item).last_name + " Guest"}</td>
                            <td>{item?.user?.email ? item?.user?.email : getConatctAddress(item).email}</td>
                            <td>{dateFormat(item?.created_at)}</td>
                            <td>${item?.amount}</td>
                          </tr>
                        ))}
                      </tbody>
                    </CustomTable>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </DashboardLayout>
  );
};

//Additional Filters
const additionalFilters = {
  type: "",
  expiryFromDate: "",
  expiryToDate: "",
};

export default withModal(withFilters(PaymentLogs, additionalFilters));
// Bind with HOC
// withModal is for Pop Up
// withFilters is for Pagination and default filters
// withPagination, if you want only pagination not filters
// additionalFilters, if you want extra filters on specific pages
