import { Formik, Form, Field } from "formik";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import CustomButton from "../../../Components/CustomButton";
import withModal from "../../../HOC/withModal";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import { dateFormat } from "../../../Utils/helper";
import FormikField from "../../../Components/FormikField";
import FieldInput from "../../../Components/Input/field";
import ImageUpload from "../../../Components/ImageUpload";
import { useNavigate } from "react-router-dom";
import { FormSelect } from "../../../Components/Select/FormSelect";
import { ProductStatus } from "../../../Config/TableStatus";
import { productValidation } from "../../../Config/Validations";
import { getAll, orderPost, post } from "../../../Services/Api";
import { useEffect, useState } from "react";
import ReactSelect from "react-select";
import { SelectField } from "../../../Components/Select/SelectField";

const AddProduct = ({ showModal }) => {
  const { startSubmitting, stopSubmitting } = useFormStatus();
  const [categoryData, setCategoryData] = useState([]);
  const [sizes, setSizes] = useState([]);
  const create = async (values, { resetForm }) => {
    console.log("|values", values);

    startSubmitting();
    const response = await orderPost("/admin/product/create", values);
    if (response.status) {
      showModal("Product Added Successfully",
        null,
        true,
        '/admin/product-management'
      );
      resetForm();
    }
    stopSubmitting();
  };

  const fetchCategories = async () => {
    const url = `/admin/category/categories/withoutPagination`;
    const response = await getAll(url);
    if (response.status) {
      let categories = [{
        value: "",
        text: "Select",
      }];
      categories = [
        ...categories,  // Spread the default option
        ...(response?.data?.map((item) => ({
          value: item.id,   // Replace 'id' with the actual property name for category ID
          text: item.name   // Replace 'name' with the actual property name for category name
        })) || [])  // Fallback to an empty array if response.data is undefined or null
      ];
      setCategoryData(categories);
    }
  };
  const fetchSizes = async () => {
    const url = `/admin/size/sizes`;
    const response = await getAll(url);
    if (response.status) {
      let options = [{
        value: "",
        label: "Select",
      }];
      options = [
        ...options,  // Spread the default option
        ...(response?.data?.map((item) => ({
          value: item.id,   // Replace 'id' with the actual property name for category ID
          label: item.name   // Replace 'name' with the actual property name for category name
        })) || [])  // Fallback to an empty array if response.data is undefined or null
      ];
      setSizes(options);
    }
  };
  useEffect(() => {
    fetchSizes();
    fetchCategories();
  }, []);
  return (
    <DashboardLayout pageTitle="Add New Product">
      <div className="dashCard mb-4">
        <h2 className="mainTitle text-uppercase">
          <BackButton />
          Add New Product
        </h2>
        <div className="statsCard mt-4">
          <Formik
            initialValues={{ name: "", status: "", description: "", category_id: "", price: "", sku: "", quantity: "", discounted_price: "", images: [], size: [] }}
            validationSchema={productValidation}
            onSubmit={create}
          >
            {({ isSubmitting, setFieldValue, errors }) => (
              <Form>
                <div className="details-wrapper">
                  <div className="row">
                    <FormikField
                      span
                      name="name"
                      label="Product Name"
                      labelClass="mainLabel"
                      placeholder="Enter Product Name"
                      className="mainInput"
                    />
                  </div>
                  <div className="row">
                    <FormikField
                      name="description"
                      label="Product Description"
                      labelClass="mainLabel"
                      as="textarea"
                      placeholder="Write Description"
                      rows={7}
                      className="mainInput"
                    />
                  </div>
                  <div className="">
                    {/* <Select
                      span
                      name="status"
                      label="Status"
                      children={generalStatus}
                      labelclass="mainLabel"
                      className="mainInput"
                    /> */}
                    <FormSelect
                      name="status"
                      label="Status"
                      options={ProductStatus}
                      labelclass="mainLabel"
                      className="mainInput"
                      span
                    />
                  </div>
                  <div className=" mt-3">
                    {/* <Select
                      span
                      name="categoru_id"
                      label="Category"
                      children={generalStatus}
                      labelclass="mainLabel"
                      className="mainInput"
                    /> */}
                    <FormSelect
                      name="category_id"
                      label="Category"
                      options={categoryData}
                      labelclass="mainLabel"
                      className="mainInput"
                      span
                    />
                  </div>
                </div>
                <div className="mt-3">
                  <ImageUpload
                    setFieldValue={setFieldValue}
                    error={errors.images}
                    initialImage=""
                  />
                </div>
                <div className="details-wrapper">
                  <div className="row">
                    <FormikField
                      span
                      name="sku"
                      label="SKU"
                      labelClass="mainLabel"
                      placeholder="Enter SKU"
                      className="mainInput"
                    />
                  </div>
                  <div className="row">
                    <FormikField
                      span
                      name="price"
                      label="Price"
                      labelClass="mainLabel"
                      placeholder="Enter Price"
                      className="mainInput"
                    />
                  </div>
                  <div className="row">
                    <FormikField
                      span
                      name="quantity"
                      label="Quantity"
                      labelClass="mainLabel"
                      placeholder="Enter Quantity"
                      className="mainInput"
                    />
                  </div>
                  {/* <div className="mt-2 mb-3">
                    <label htmlFor="" className="mainLabel">Size <span className="redColor">*</span></label>
                    <ReactSelect isMulti options={sizes} />
                  </div> */}
                  <div className="mt-2 mb-3">
                    <label htmlFor="size" className="mainLabel">Size <span className="redColor">*</span></label>
                    <Field
                      name="size"
                      component={SelectField}
                      options={sizes}
                      isMulti
                    />
                  </div>
                  <div className="row">
                    <FormikField
                      span
                      name="discounted_price"
                      label="Discounted Price"
                      labelClass="mainLabel"
                      placeholder="Enter Discounted Price"
                      className="mainInput"
                    />
                  </div>
                </div>
                <div className="row mt-4">
                  <div className="col-md-12">
                    <CustomButton
                      variant="btnBlueBG"
                      className="px-5"
                      text="Add"
                      pendingText="Submitting..."
                      isPending={isSubmitting}
                      type="submit"
                    />
                  </div>
                </div>
              </Form>
            )}
          </Formik>

        </div>
      </div>
    </DashboardLayout>
  );
};

export default withModal(AddProduct);
