import { Formik, Form, Field } from "formik";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import CustomButton from "../../../Components/CustomButton";
import { ImageSliderMultiple } from "../../../Components/ImageSliderMultiple";
import SiteInput from "../../../Components/Input/input";
import withModal from "../../../HOC/withModal";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import { dateFormat } from "../../../Utils/helper";
import FormikField from "../../../Components/FormikField";
import FieldInput from "../../../Components/Input/field";
import ImageUpload from "../../../Components/ImageUpload";
import { useNavigate, useParams } from "react-router-dom";
import { useEffect, useState } from "react";
import { categoryManagementData, productsManagementData } from "../../../Config/data";
import { Select } from "../../../Components/Select";
import { generalStatus, ProductStatus } from "../../../Config/TableStatus";
import { getAll, getDetails, orderPost, post } from "../../../Services/Api";
import { FormSelect } from "../../../Components/Select/FormSelect";
import { updateProductValidation } from "../../../Config/Validations";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faTimes } from "@fortawesome/free-solid-svg-icons";
import { SelectField } from "../../../Components/Select/SelectField";


const EditProduct = ({ showModal }) => {
  const { startSubmitting, stopSubmitting, isSubmitting } = useFormStatus();
  const [data, setData] = useState({});
  const [categoryData, setCategoryData] = useState([]);
  const [sizes, setSizes] = useState([]);
  const [imagesData, setImagesData] = useState([]);
  const { id } = useParams();
  const create = async (values, { resetForm }) => {
    startSubmitting()
    const response = await orderPost(`/admin/product/${id}/update`, values);
    if (response.status) {
      showModal("Product Updated Successfully", null,
        true,
        '/admin/product-management'
      );
      resetForm();
    }

    stopSubmitting();
  };
  const getProduct = async () => {
    startSubmitting();
    const response = await getDetails(`/admin/product/${id}`);
    if (response.status) {
      setData(response.data);
      setImagesData(response?.data?.images)
      stopSubmitting();
    }
    stopSubmitting();
  };
  const fetchCategories = async () => {
    const url = `/admin/category/categories/withoutPagination`;
    const response = await getAll(url);
    if (response.status) {
      let categories = [{
        value: "",
        text: "Select",
      }];
      categories = [
        ...categories,  // Spread the default option
        ...(response?.data?.map((item) => ({
          value: item.id,   // Replace 'id' with the actual property name for category ID
          text: item.name   // Replace 'name' with the actual property name for category name
        })) || [])  // Fallback to an empty array if response.data is undefined or null
      ];
      setCategoryData(categories);
    }
  };
  const confirmPopup = (id) => {
    showModal(
      `Are you sure you want to delete this Image?`,
      () => handleDeleteImage(id)
    );
  };
  const handleDeleteImage = async (id) => {
    const url = `/admin/product/deleteImage/${id}`;
    const response = await getAll(url);
    if (response.status) {
      setImagesData(response?.data);
      showModal(
        `Image deleted successfully`, //heading
        null, //action
        true //sucess
      );
    }
  }
  const fetchSizes = async () => {
    const url = `/admin/size/sizes`;
    const response = await getAll(url);
    if (response.status) {
      let options = [{
        value: "",
        label: "Select",
      }];
      options = [
        ...options,  // Spread the default option
        ...(response?.data?.map((item) => ({
          value: item.id,   // Replace 'id' with the actual property name for category ID
          label: item.name   // Replace 'name' with the actual property name for category name
        })) || [])  // Fallback to an empty array if response.data is undefined or null
      ];
      setSizes(options);
    }
  };
  useEffect(() => {
    getProduct();
    fetchSizes();
    fetchCategories();
  }, [id]);
  const initialValues = {
    name: data?.name,
    status: data?.status,
    description: data?.description,
    category_id: data?.category?.id,
    price: data?.price,
    sku: data?.sku,
    quantity: data?.quantity,
    discounted_price: data?.discounted_price,
    images: [],
    size: data?.product_sizes
      ? data?.product_sizes.map(size => ({
        value: size.id,
        label: size.name
      }))
      : []
  };

  return (
    <DashboardLayout pageTitle="Edit Product">
      <div className="dashCard mb-4">
        <h2 className="mainTitle text-uppercase">
          <BackButton />
          Edit Product
        </h2>
        <div className="statsCard mt-4">
          {isSubmitting ? (
            <div>Loading...</div>
          ) : (
            Object.keys(data).length > 0 && (
              <Formik
                initialValues={initialValues}
                validationSchema={updateProductValidation}
                onSubmit={create}
              >
                {({ isSubmitting, errors, setFieldValue }) => (
                  <Form>
                    <div className="details-wrapper">
                      <div className="row">
                        <FormikField
                          span
                          name="name"
                          label="Product Name"
                          labelClass="mainLabel"
                          placeholder="Enter Product Name"
                          className="mainInput"
                        />
                      </div>
                      <div className="row">
                        <FormikField
                          name="description"
                          label="Product Description"
                          labelClass="mainLabel"
                          as="textarea"
                          placeholder="Write Description"
                          rows={7}
                          className="mainInput"
                        />
                      </div>
                      <div className="">
                        {/* <Select
                        span
                        name="status"
                        label="Status"
                        children={generalStatus}
                        labelclass="mainLabel"
                        className="mainInput"
                      /> */}
                        <FormSelect
                          name="status"
                          label="Status"
                          options={ProductStatus}
                          labelclass="mainLabel"
                          className="mainInput"
                          span
                        />
                      </div>
                      <div className=" mt-3">
                        {/* <Select
                        span
                        name="category"
                        label="Category"
                        children={categoryOptions}
                        labelclass="mainLabel"
                        className="mainInput"
                      /> */}
                        <FormSelect
                          name="category_id"
                          label="Category"
                          options={categoryData}
                          labelclass="mainLabel"
                          className="mainInput"
                          span
                        />
                      </div>
                    </div>
                    <div className="mt-3">
                      <ImageUpload
                        setFieldValue={setFieldValue}
                        error={errors.images}
                        initialImage={data?.images || []}  // Use data.images directly
                        name="images"
                      />
                    </div>
                    <div className="d-flex my-3 align-items-center gap-3 flex-wrap">
                      {imagesData?.length > 0 && imagesData?.map((image, index) => (
                        <div className="position-relative" key={index}>
                          <img
                            src={image?.path}
                            alt={`Uploaded ${index}`}
                            className="uploaded preview-img"
                            // onClick={() => handleImageClick(index)}
                            style={{ cursor: 'pointer' }}
                          />
                          <button
                            type="button"
                            className="transparent-btn"
                            style={{ position: 'absolute', top: 0, right: 0 }}
                            onClick={() => confirmPopup(image?.id)}
                          >
                            <FontAwesomeIcon icon={faTimes} />
                          </button>
                        </div>
                      ))}
                    </div>
                    <div className="details-wrapper">
                      <div className="row">
                        <FormikField
                          span
                          name="sku"
                          label="SKU"
                          labelClass="mainLabel"
                          placeholder="Enter SKU"
                          className="mainInput"
                        />
                      </div>
                      <div className="row">
                        <FormikField
                          span
                          name="price"
                          label="Price"
                          labelClass="mainLabel"
                          placeholder="Enter Price"
                          className="mainInput"
                        />
                      </div>
                      <div className="row">
                        <FormikField
                          span
                          name="quantity"
                          label="Quantity"
                          labelClass="mainLabel"
                          placeholder="Enter Quantity"
                          className="mainInput"
                        />
                      </div>
                      <div className="mt-2 mb-3">
                        <label htmlFor="size" className="mainLabel">
                          Size <span className="redColor">*</span>
                        </label>
                        <Field
                          name="size"
                          component={SelectField}
                          options={sizes}  // Pass the available size options
                          isMulti={true}   // Enable multi-select
                        />
                      </div>
                      <div className="row">
                        <FormikField
                          span
                          name="discounted_price"
                          label="Discounted Price"
                          labelClass="mainLabel"
                          placeholder="Enter Discounted Price"
                          className="mainInput"
                        />
                      </div>
                    </div>
                    <div className="row mt-4">
                      <div className="col-md-12">
                        <CustomButton
                          variant="btnBlueBG"
                          className="px-5"
                          text="Update"
                          pendingText="Submitting..."
                          isPending={isSubmitting}
                          type="submit"
                        />
                      </div>
                    </div>
                  </Form>
                )}
              </Formik>
            )
          )}

        </div>
      </div>
    </DashboardLayout>
  );
};

export default withModal(EditProduct);
